/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.walk;

import java.util.HashSet;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.walk.Visitor;

public abstract class Walker {
    public abstract <R, E extends Throwable> R accept(Visitor<R, E> var1) throws E;

    public static Walker fullGraph(final GraphDatabaseService graphDb) {
        return new Walker(){

            @Override
            public <R, E extends Throwable> R accept(Visitor<R, E> visitor) throws E {
                for (Node node : graphDb.getAllNodes()) {
                    visitor.visitNode(node);
                    for (Relationship edge : node.getRelationships(Direction.OUTGOING)) {
                        visitor.visitRelationship(edge);
                    }
                }
                return visitor.done();
            }
        };
    }

    public static Walker crosscut(Iterable<Node> traverser, final RelationshipType ... types) {
        final HashSet<Node> nodes = new HashSet<Node>();
        for (Node node : traverser) {
            nodes.add(node);
        }
        return new Walker(){

            @Override
            public <R, E extends Throwable> R accept(Visitor<R, E> visitor) throws E {
                for (Node node : nodes) {
                    visitor.visitNode(node);
                    for (Relationship relationship : node.getRelationships(types)) {
                        if (!nodes.contains(relationship.getOtherNode(node))) continue;
                        visitor.visitRelationship(relationship);
                    }
                }
                return visitor.done();
            }
        };
    }
}

