/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz.color;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.visualization.graphviz.color.Color;

public class DefaultColorMapping<E> {
    private final List<String> availableColors = new ArrayList<String>();
    private int usedAvailableColors = 0;
    private final Map<E, String> colorMappings = new HashMap<E, String>();

    public DefaultColorMapping() {
        this(Collections.emptyList());
    }

    public DefaultColorMapping(Collection<Color> reservedColors) {
        Color[] existingColors;
        for (Color color : existingColors = Color.values()) {
            if (reservedColors.contains((Object)color)) continue;
            this.availableColors.add(color.dark);
        }
        for (Color color : existingColors) {
            if (reservedColors.contains((Object)color)) continue;
            this.availableColors.add(color.light);
        }
    }

    protected String getColor(E key) {
        String color = this.colorMappings.get(key);
        if (color == null) {
            color = this.availableColors.get(this.usedAvailableColors % this.availableColors.size());
            ++this.usedAvailableColors;
            this.colorMappings.put(key, color);
        }
        return color;
    }

    protected String getColor(Color color) {
        return color.dark;
    }
}

