/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz.color;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.visualization.graphviz.StyleParameter;
import org.neo4j.visualization.graphviz.color.Color;
import org.neo4j.visualization.graphviz.color.ColorMapper;
import org.neo4j.visualization.graphviz.color.DefaultColorMapping;

public class AutoNodeColor
extends StyleParameter.NodeColor {
    private final DefaultColorMapping<Set<String>> colors;
    private Direction[] directions;
    private boolean differentiateOnDirection;
    private boolean differentiateOnDirectionOnly = false;
    private ColorMapper<Node> ncm = null;

    public AutoNodeColor() {
        NodeColorConfig.DEFAULT.configure(this);
        this.colors = new DefaultColorMapping();
    }

    public AutoNodeColor(ColorMapper<Node> ncm) {
        NodeColorConfig.DEFAULT.configure(this);
        this.colors = new DefaultColorMapping(ncm.getColors());
        this.ncm = ncm;
    }

    public AutoNodeColor(NodeColorConfig config) {
        config.configure(this);
        this.colors = new DefaultColorMapping();
    }

    public AutoNodeColor(NodeColorConfig config, ColorMapper<Node> ncm) {
        config.configure(this);
        this.colors = new DefaultColorMapping(ncm.getColors());
        this.ncm = ncm;
    }

    @Override
    protected String getColor(Node node) {
        Color color;
        if (this.ncm != null && (color = this.ncm.getColor(node)) != null) {
            return this.colors.getColor(color);
        }
        HashSet<String> relationshipTypeAndDirections = new HashSet<String>();
        for (Direction direction : this.directions) {
            if (this.differentiateOnDirectionOnly) {
                if (!node.hasRelationship(direction)) continue;
                relationshipTypeAndDirections.add(direction.name());
                continue;
            }
            for (Relationship relationship : node.getRelationships(direction)) {
                String key = relationship.getType().name();
                if (this.differentiateOnDirection) {
                    key = key + direction.name();
                }
                relationshipTypeAndDirections.add(key);
            }
        }
        return this.colors.getColor(relationshipTypeAndDirections);
    }

    static /* synthetic */ Direction[] access$102(AutoNodeColor x0, Direction[] x1) {
        x0.directions = x1;
        return x1;
    }

    public static enum NodeColorConfig {
        DEFAULT{

            @Override
            void configure(AutoNodeColor style) {
                BOTH_IGNORE_DIRECTION.configure(style);
            }
        }
        ,
        BOTH{

            @Override
            void configure(AutoNodeColor style) {
                AutoNodeColor.access$102(style, new Direction[]{Direction.INCOMING, Direction.OUTGOING});
                style.differentiateOnDirection = true;
            }
        }
        ,
        BOTH_IGNORE_DIRECTION{

            @Override
            void configure(AutoNodeColor style) {
                AutoNodeColor.access$102(style, new Direction[]{Direction.INCOMING, Direction.OUTGOING});
                style.differentiateOnDirection = false;
            }
        }
        ,
        INCOMING{

            @Override
            void configure(AutoNodeColor style) {
                AutoNodeColor.access$102(style, new Direction[]{Direction.INCOMING});
                style.differentiateOnDirection = false;
            }
        }
        ,
        OUTGOING{

            @Override
            void configure(AutoNodeColor style) {
                AutoNodeColor.access$102(style, new Direction[]{Direction.OUTGOING});
                style.differentiateOnDirection = false;
            }
        }
        ,
        DIRECTION{

            @Override
            void configure(AutoNodeColor style) {
                AutoNodeColor.access$102(style, new Direction[]{Direction.INCOMING, Direction.OUTGOING});
                style.differentiateOnDirectionOnly = true;
            }
        };


        abstract void configure(AutoNodeColor var1);
    }
}

