/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import java.io.IOException;
import java.util.Iterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.visualization.graphviz.DefaultNodeStyle;
import org.neo4j.visualization.graphviz.DefaultStyleConfiguration;

public class SimpleNodeStyle
extends DefaultNodeStyle {
    boolean hasLabels = false;

    SimpleNodeStyle(DefaultStyleConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void emitNodeStart(Appendable stream, Node node) throws IOException {
        stream.append("  N" + node.getId() + " [\n");
        this.config.emit(node, stream);
        stream.append("    label = \"");
        Iterator labels = node.getLabels().iterator();
        this.hasLabels = labels.hasNext();
        if (this.hasLabels) {
            this.hasLabels = labels.hasNext();
            if (this.hasLabels) {
                stream.append("{");
                while (labels.hasNext()) {
                    stream.append(((Label)labels.next()).name());
                    if (!labels.hasNext()) continue;
                    stream.append(", ");
                }
                stream.append("|");
            }
        }
    }

    @Override
    public void emitEnd(Appendable stream) throws IOException {
        if (this.hasLabels) {
            stream.append("}\"\n  ]\n");
        } else {
            stream.append("\"\n  ]\n");
        }
    }
}

