/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.visualization.graphviz.ConfigurationParser;
import org.neo4j.visualization.graphviz.GraphvizWriter;
import org.neo4j.visualization.graphviz.StyleParameter;
import org.neo4j.walk.Walker;

public class Script
extends ConfigurationParser {
    protected File storeDir;

    public Script(File config, String ... format) {
        super(config, format);
    }

    public Script(String ... format) {
        super(format);
    }

    public static <S extends Script> S initialize(Class<S> scriptClass, String ... args) {
        Script script;
        block14: {
            if (args.length < 1) {
                throw new IllegalArgumentException("GraphvizWriter expects at least one  argument, the path to the Neo4j storage dir.");
            }
            String[] format = new String[args.length - 1];
            System.arraycopy(args, 1, format, 0, format.length);
            String configFile = System.getProperty("org.neo4j.visualization.ConfigFile", null);
            script = null;
            try {
                Constructor<S> ctor;
                block13: {
                    if (configFile != null) {
                        try {
                            ctor = scriptClass.getConstructor(File.class, String[].class);
                            script = (Script)ctor.newInstance(new File(configFile), format);
                        }
                        catch (NoSuchMethodException handled) {
                            if (format != null && format.length != 0) break block13;
                            try {
                                ctor = scriptClass.getConstructor(File.class);
                                script = (Script)ctor.newInstance(new File(configFile));
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (script != null) break block14;
                try {
                    ctor = scriptClass.getConstructor(String[].class);
                    script = (Script)ctor.newInstance(new Object[]{format});
                }
                catch (NoSuchMethodException exception) {
                    if (format == null || format.length == 0) {
                        script = (Script)scriptClass.newInstance();
                        break block14;
                    }
                    throw exception;
                }
            }
            catch (NoSuchMethodException e) {
                throw new UnsupportedOperationException(scriptClass.getName() + " does not have a suitable constructor", e);
            }
            catch (InvocationTargetException e) {
                throw new UnsupportedOperationException("Could not initialize script", e.getTargetException());
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Could not initialize script", e);
            }
        }
        script.storeDir = new File(args[0]);
        return (S)script;
    }

    public static void main(Class<? extends Script> scriptClass, String ... args) {
        Script.initialize(scriptClass, args).emit(new File(System.getProperty("graphviz.out", "graph.dot")));
    }

    public static void main(String ... args) {
        Script.main(Script.class, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void emit(File outfile) {
        GraphDatabaseService graphdb = this.createGraphDb();
        GraphvizWriter writer = new GraphvizWriter(this.styles(new StyleParameter[0]));
        try (Transaction tx = graphdb.beginTx();){
            writer.emit(outfile, this.createGraphWalker(graphdb));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            graphdb.shutdown();
        }
    }

    protected File storeDir() {
        return this.storeDir;
    }

    protected GraphDatabaseService createGraphDb() {
        return new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDir());
    }

    protected Walker createGraphWalker(GraphDatabaseService graphdb) {
        return Walker.fullGraph(graphdb);
    }
}

