/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import java.io.IOException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.visualization.PropertyType;
import org.neo4j.visualization.graphviz.DefaultStyleConfiguration;
import org.neo4j.visualization.graphviz.RelationshipStyle;

class DefaultRelationshipStyle
implements RelationshipStyle {
    private final DefaultStyleConfiguration config;

    DefaultRelationshipStyle(DefaultStyleConfiguration configuration) {
        this.config = configuration;
    }

    @Override
    public void emitRelationshipStart(Appendable stream, Relationship relationship) throws IOException {
        Node start = relationship.getStartNode();
        Node end = relationship.getEndNode();
        boolean reversed = this.config.reverseOrder(relationship);
        long startId = start.getId();
        long endId = end.getId();
        if (reversed) {
            long tmp = startId;
            startId = endId;
            endId = tmp;
        }
        stream.append("  N" + startId + " -> N" + endId + " [\n");
        this.config.emit(relationship, stream);
        if (reversed) {
            stream.append("    dir = back\n");
        }
        if (this.config.displayRelationshipLabel) {
            stream.append("    label = \"" + this.config.escapeLabel(this.config.getTitle(relationship)) + "\\n");
        }
    }

    @Override
    public void emitEnd(Appendable stream) throws IOException {
        stream.append(this.config.displayRelationshipLabel ? "\"\n  ]\n" : "  ]\n");
    }

    @Override
    public void emitProperty(Appendable stream, String key, Object value) throws IOException {
        if (this.config.displayRelationshipLabel && this.config.acceptEdgeProperty(key)) {
            PropertyType type = PropertyType.getTypeOf(value);
            this.config.emitRelationshipProperty(stream, key, type, value);
        }
    }
}

