/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import java.io.IOException;
import java.util.Iterator;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.visualization.PropertyType;
import org.neo4j.visualization.graphviz.DefaultStyleConfiguration;
import org.neo4j.visualization.graphviz.NodeStyle;

class DefaultNodeStyle
implements NodeStyle {
    protected final DefaultStyleConfiguration config;

    DefaultNodeStyle(DefaultStyleConfiguration configuration) {
        this.config = configuration;
    }

    @Override
    public void emitNodeStart(Appendable stream, Node node) throws IOException {
        stream.append("  N" + node.getId() + " [\n");
        this.config.emit(node, stream);
        stream.append("    label = \"{" + this.config.escapeLabel(this.config.getTitle(node)));
        Iterator labels = node.getLabels().iterator();
        if (labels.hasNext() && labels.hasNext()) {
            stream.append(": ");
            while (labels.hasNext()) {
                stream.append(((Label)labels.next()).name());
                if (!labels.hasNext()) continue;
                stream.append(", ");
            }
        }
        stream.append("|");
    }

    @Override
    public void emitEnd(Appendable stream) throws IOException {
        stream.append("}\"\n  ]\n");
    }

    @Override
    public void emitProperty(Appendable stream, String key, Object value) throws IOException {
        if (this.config.acceptNodeProperty(key)) {
            PropertyType type = PropertyType.getTypeOf(value);
            this.config.emitNodeProperty(stream, key, type, value);
        }
    }
}

