/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.ArrayIterator;
import org.neo4j.helpers.collection.CombiningIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.visualization.graphviz.StyleParameter;

public class ConfigurationParser {
    private final List<StyleParameter> styles = new ArrayList<StyleParameter>();

    public ConfigurationParser(File configFile, String ... format) {
        this(Iterators.asIterable((Iterator)new CombiningIterator(Arrays.asList(new Iterator[]{new LineIterator(configFile), new ArrayIterator((Object[])format)}))));
    }

    public ConfigurationParser(String ... format) {
        this(Iterators.asIterable((Iterator)new ArrayIterator((Object[])format)));
    }

    public ConfigurationParser(Iterable<String> format) {
        Class<?> type = this.getClass();
        for (String spec : format) {
            String[] parts = spec.split("=", 2);
            String name = parts[0];
            String[] args = null;
            Throwable error = null;
            try {
                Method method;
                if (parts.length == 1) {
                    method = type.getMethod(name, String[].class);
                } else {
                    try {
                        method = type.getMethod(name, String.class);
                        args = new String[]{parts[1]};
                    }
                    catch (NoSuchMethodException nsm) {
                        error = nsm;
                        method = type.getMethod(name, String[].class);
                        args = parts[1].split(",");
                    }
                }
                try {
                    if (error == null) {
                        method.invoke((Object)this, (Object[])args);
                    } else {
                        error = null;
                        method.invoke((Object)this, new Object[]{args});
                    }
                }
                catch (InvocationTargetException ex) {
                    error = ex.getTargetException();
                    if (error instanceof RuntimeException) {
                        throw (RuntimeException)error;
                    }
                }
                catch (Exception ex) {
                    error = ex;
                }
            }
            catch (NoSuchMethodException nsm) {
                error = nsm;
            }
            if (error == null) continue;
            throw new IllegalArgumentException("Unknown parameter \"" + name + "\"", error);
        }
    }

    public final StyleParameter[] styles(StyleParameter ... params) {
        if (params == null) {
            params = new StyleParameter[]{};
        }
        StyleParameter[] result = this.styles.toArray(new StyleParameter[this.styles.size() + params.length]);
        System.arraycopy(params, 0, result, this.styles.size(), params.length);
        return result;
    }

    public void nodeTitle(String pattern) {
        final PatternParser parser = new PatternParser(pattern);
        this.styles.add(new StyleParameter.NodeTitle(){

            @Override
            public String getTitle(Node container) {
                return parser.parse((PropertyContainer)container);
            }
        });
    }

    public void relationshipTitle(String pattern) {
        final PatternParser parser = new PatternParser(pattern);
        this.styles.add(new StyleParameter.RelationshipTitle(){

            @Override
            public String getTitle(Relationship container) {
                return parser.parse((PropertyContainer)container);
            }
        });
    }

    public void nodePropertyFilter(String nodeProperties) {
        final String nodePropertiesString = nodeProperties;
        this.styles.add(new StyleParameter.NodePropertyFilter(){

            @Override
            public boolean acceptProperty(String key) {
                return Arrays.asList(nodePropertiesString.split(",")).contains(key);
            }
        });
    }

    public void reverseOrder(String ... typeNames) {
        if (typeNames == null || typeNames.length == 0) {
            return;
        }
        RelationshipType[] types = new RelationshipType[typeNames.length];
        for (int i = 0; i < typeNames.length; ++i) {
            types[i] = RelationshipType.withName((String)typeNames[i]);
        }
        this.styles.add(new StyleParameter.ReverseOrderRelationshipTypes(types));
    }

    private static class LineIterator
    extends PrefetchingIterator<String> {
        private final BufferedReader reader;

        public LineIterator(BufferedReader reader) {
            this.reader = reader;
        }

        public LineIterator(File file) {
            this(LineIterator.fileReader(file));
        }

        private static BufferedReader fileReader(File file) {
            try {
                return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        protected String fetchNextOrNull() {
            try {
                return this.reader.readLine();
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static class PatternParser {
        private final String pattern;

        PatternParser(String pattern) {
            this.pattern = pattern;
        }

        String parse(PropertyContainer container) {
            StringBuilder result = new StringBuilder();
            int pos = 0;
            while (pos < this.pattern.length()) {
                String key;
                char cur;
                if ((cur = this.pattern.charAt(pos++)) == '@') {
                    key = this.untilNonAlfa(pos);
                    result.append(this.getSpecial(key, container));
                    pos += key.length();
                    continue;
                }
                if (cur == '$') {
                    key = this.pattern.charAt(pos) == '{' ? this.pattern.substring(++pos, this.pattern.indexOf(125, pos++)) : this.untilNonAlfa(pos);
                    pos += this.pattern.length();
                    result.append(container.getProperty(key));
                    continue;
                }
                if (cur == '\\') {
                    result.append(this.pattern.charAt(pos++));
                    continue;
                }
                result.append(cur);
            }
            return result.toString();
        }

        private String untilNonAlfa(int start) {
            int end;
            for (end = start; end < this.pattern.length() && Character.isLetter(this.pattern.charAt(end)); ++end) {
            }
            return this.pattern.substring(start, end);
        }

        private String getSpecial(String attribute, PropertyContainer container) {
            if (attribute.equals("id")) {
                if (container instanceof Node) {
                    return "" + ((Node)container).getId();
                }
                if (container instanceof Relationship) {
                    return "" + ((Relationship)container).getId();
                }
            } else if (attribute.equals("type") && container instanceof Relationship) {
                return ((Relationship)container).getType().name();
            }
            return "@" + attribute;
        }
    }
}

