/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization;

import java.util.HashSet;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.visualization.GraphRenderer;
import org.neo4j.visualization.PropertyRenderer;
import org.neo4j.walk.Visitor;

public class Visualizer<E extends Throwable>
implements Visitor<Void, E> {
    private final GraphRenderer<E> renderer;
    private Set<Relationship> visitedRelationships = new HashSet<Relationship>();
    private Set<Node> visitedNodes = new HashSet<Node>();

    public Visualizer(GraphRenderer<E> renderer) {
        this.renderer = renderer;
    }

    @Override
    public Void done() throws E {
        this.renderer.done();
        return null;
    }

    @Override
    public void visitNode(Node node) throws E {
        if (this.visitedNodes.add(node)) {
            this.renderProperties(this.renderer.renderNode(node), (PropertyContainer)node);
        }
    }

    @Override
    public void visitRelationship(Relationship relationship) throws E {
        if (this.visitedRelationships.add(relationship)) {
            this.renderProperties(this.renderer.renderRelationship(relationship), (PropertyContainer)relationship);
        }
    }

    @Override
    public Visitor<Void, E> visitSubgraph(String name) throws E {
        return new Visualizer<E>(this.renderer.renderSubgraph(name));
    }

    private void renderProperties(PropertyRenderer<E> propertyRenderer, PropertyContainer container) throws E {
        for (String key : container.getPropertyKeys()) {
            propertyRenderer.renderProperty(key, container.getProperty(key));
        }
        propertyRenderer.done();
    }
}

