/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization;

import java.util.Arrays;
import org.neo4j.visualization.PropertyType;

public interface ValueFormatter<T> {
    public static final ValueFormatter<String> DEFAULT_STRING_FORMATTER = new ValueFormatter<String>(){

        @Override
        public String formatString(String string) {
            string = string.replace("\\n", "\\\\n");
            string = string.replace("\\", "\\\\");
            string = string.replace("\"", "\\\"");
            string = string.replace("'", "\\\\'");
            string = string.replace("\n", "\\\\n");
            string = string.replace("<", "\\<");
            string = string.replace(">", "\\>");
            string = string.replace("[", "\\[");
            string = string.replace("]", "\\]");
            string = string.replace("{", "\\{");
            string = string.replace("}", "\\}");
            string = string.replace("|", "\\|");
            return "'" + string + "'";
        }

        @Override
        public String formatStringArray(String[] value) {
            boolean comma = false;
            StringBuilder result = new StringBuilder("[");
            for (String string : value) {
                if (comma) {
                    result.append(", ");
                }
                result.append(this.formatString(string));
                comma = true;
            }
            result.append("]");
            return result.toString();
        }

        @Override
        public String formatBoxedPrimitive(PropertyType type, Object primitive) {
            return primitive.toString();
        }

        @Override
        public String formatBoxedPrimitiveArray(PropertyType elementType, Object[] array) {
            return Arrays.toString(array);
        }

        @Override
        public String formatPrimitiveArray(PropertyType type, Object array) {
            switch (type) {
                case INT: {
                    return Arrays.toString((int[])array);
                }
                case LONG: {
                    return Arrays.toString((long[])array);
                }
                case BOOLEAN: {
                    return Arrays.toString((boolean[])array);
                }
                case SHORT: {
                    return Arrays.toString((short[])array);
                }
                case CHAR: {
                    return Arrays.toString((char[])array);
                }
                case BYTE: {
                    return Arrays.toString((byte[])array);
                }
                case FLOAT: {
                    return Arrays.toString((float[])array);
                }
                case DOUBLE: {
                    return Arrays.toString((double[])array);
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String formatUnknownObject(Object value) {
            return value.toString();
        }
    };

    public T formatString(String var1);

    public T formatStringArray(String[] var1);

    public T formatBoxedPrimitive(PropertyType var1, Object var2);

    public T formatPrimitiveArray(PropertyType var1, Object var2);

    public T formatBoxedPrimitiveArray(PropertyType var1, Object[] var2);

    public T formatUnknownObject(Object var1);
}

