/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.walk.Visitor;
import org.neo4j.walk.Walker;

public interface SubgraphMapper {
    public String getSubgraphFor(Node var1);

    public static abstract class SubgraphMappingWalker
    extends Walker {
        private final SubgraphMapper mapper;
        private Map<String, Collection<Node>> subgraphs;
        private Collection<Node> generic;
        private Collection<Relationship> relationships;

        protected SubgraphMappingWalker(SubgraphMapper mapper) {
            this.mapper = mapper;
        }

        private synchronized void initialize() {
            if (this.subgraphs != null) {
                return;
            }
            HashMap<Node, String> mappings = new HashMap<Node, String>();
            this.subgraphs = new HashMap<String, Collection<Node>>();
            this.generic = new ArrayList<Node>();
            for (Node node : this.nodes()) {
                if (mappings.containsKey(node)) continue;
                String subgraph = this.subgraphFor(node);
                if (!this.subgraphs.containsKey(subgraph) && subgraph != null) {
                    this.subgraphs.put(subgraph, new ArrayList());
                }
                mappings.put(node, subgraph);
            }
            this.relationships = new ArrayList<Relationship>();
            for (Relationship relationship : this.relationships()) {
                if (!mappings.containsKey(relationship.getStartNode()) || !mappings.containsKey(relationship.getEndNode())) continue;
                this.relationships.add(relationship);
            }
            for (Map.Entry entry : mappings.entrySet()) {
                (entry.getValue() == null ? this.generic : this.subgraphs.get(entry.getValue())).add((Node)entry.getKey());
            }
        }

        private String subgraphFor(Node node) {
            return this.mapper == null ? null : this.mapper.getSubgraphFor(node);
        }

        @Override
        public final <R, E extends Throwable> R accept(Visitor<R, E> visitor) throws E {
            this.initialize();
            for (Map.Entry<String, Collection<Node>> subgraph : this.subgraphs.entrySet()) {
                Visitor<R, E> subVisitor = visitor.visitSubgraph(subgraph.getKey());
                for (Node node : subgraph.getValue()) {
                    subVisitor.visitNode(node);
                }
                subVisitor.done();
            }
            for (Node node : this.generic) {
                visitor.visitNode(node);
            }
            for (Relationship relationship : this.relationships) {
                visitor.visitRelationship(relationship);
            }
            return visitor.done();
        }

        protected abstract Iterable<Node> nodes();

        protected abstract Iterable<Relationship> relationships();
    }
}

