/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.visualization.ValueFormatter;

public enum PropertyType {
    STRING(null, "String", new Class[]{String.class}){

        @Override
        <T> T apply(ValueFormatter<T> formatter, Object value) {
            return formatter.formatString((String)value);
        }
    }
    ,
    INT(null, "int", Integer.class, Integer.TYPE),
    LONG(null, "long", Long.class, Long.TYPE),
    BOOLEAN(null, "boolean", Boolean.class, Boolean.TYPE),
    SHORT(null, "short", Short.class, Short.TYPE),
    CHAR(null, "char", Character.class, Character.TYPE),
    BYTE(null, "byte", Byte.class, Byte.TYPE),
    FLOAT(null, "float", Float.class, Float.TYPE),
    DOUBLE(null, "double", Double.class, Double.TYPE),
    STRING_ARRAY((Class)String.class, "String[]", new Class[]{String[].class}){

        @Override
        <T> T apply(ValueFormatter<T> formatter, Object value) {
            return formatter.formatStringArray((String[])value);
        }
    }
    ,
    INT_ARRAY(Integer.class, "int[]", Integer[].class, int[].class),
    LONG_ARRAY(Long.class, "long[]", Long[].class, long[].class),
    BOOLEAN_ARRAY(Boolean.class, "boolean[]", Boolean[].class, boolean[].class),
    SHORT_ARRAY(Short.class, "short[]", Short[].class, short[].class),
    CHAR_ARRAY(Character.class, "char[]", Character[].class, char[].class),
    BYTE_ARRAY(Byte.class, "byte[]", Byte[].class, byte[].class),
    FLOAT_ARRAY(Float.class, "float[]", Float[].class, float[].class),
    DOUBLE_ARRAY(Double.class, "double[]", Double[].class, double[].class),
    UNDEFINED(null, "Object", new Class[0]){

        @Override
        <T> T apply(ValueFormatter<T> formatter, Object value) {
            return formatter.formatUnknownObject(value);
        }
    };

    private final Class<?>[] types;
    private final Class<?> scalarType;
    public final String typeName;
    private static final Map<Class<?>, PropertyType> typeMap;

    public static PropertyType getTypeOf(Object propertyValue) {
        return PropertyType.getTypeFor(propertyValue.getClass());
    }

    static PropertyType getTypeFor(Class<? extends Object> type) {
        PropertyType result = typeMap.get(type);
        if (result != null) {
            return result;
        }
        return UNDEFINED;
    }

    <T> T apply(ValueFormatter<T> formatter, Object value) {
        if (this.scalarType != null) {
            PropertyType type = PropertyType.getTypeFor(this.scalarType);
            if (value instanceof Object[]) {
                return formatter.formatBoxedPrimitiveArray(type, (Object[])value);
            }
            return formatter.formatPrimitiveArray(type, value);
        }
        return formatter.formatBoxedPrimitive(this, value);
    }

    public static <T> T format(ValueFormatter<T> formatter, Object propertyValue) {
        return PropertyType.getTypeOf(propertyValue).apply(formatter, propertyValue);
    }

    public static String format(Object propertyValue) {
        return PropertyType.format(ValueFormatter.DEFAULT_STRING_FORMATTER, propertyValue);
    }

    private PropertyType(Class<?> scalarType, String descriptor, Class<?> ... types) {
        this.typeName = descriptor;
        this.types = types;
        this.scalarType = scalarType;
    }

    static {
        HashMap types = new HashMap();
        for (PropertyType type : PropertyType.values()) {
            for (Class<?> cls : type.types) {
                types.put(cls, type);
            }
        }
        typeMap = Collections.unmodifiableMap(types);
    }
}

