/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.visualization.asciidoc.AsciidocHelper;

public class AsciidocHelperTest {
    @Test
    public void test() {
        String cypher = "start n=node(0) match x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n, x-n return n, x";
        String snippet = AsciidocHelper.createCypherSnippet((String)cypher);
        Assert.assertTrue((boolean)snippet.contains("n,\n"));
    }

    @Test
    public void shouldBreakAtTheRightSpotWithOnMatch() {
        String cypher = "merge (a)\non match set a.foo = 2";
        String snippet = AsciidocHelper.createCypherSnippet((String)cypher);
        Assert.assertEquals((Object)"[source,cypher]\n----\nMERGE (a)\nON MATCH SET a.foo = 2\n----\n", (Object)snippet);
    }

    @Test
    public void testUpcasingLabels() {
        String queryString = "create n label :Person {} on tail";
        String snippet = AsciidocHelper.createCypherSnippet((String)queryString);
        Assert.assertTrue((boolean)snippet.contains("LABEL"));
        Assert.assertTrue((boolean)snippet.contains("ON"));
        Assert.assertFalse((boolean)snippet.contains(":PersON"));
    }
}

