/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.neo4j.visualization.graphviz.DefaultNodeStyle;
import org.neo4j.visualization.graphviz.DefaultRelationshipStyle;
import org.neo4j.visualization.graphviz.DefaultStyleConfiguration;
import org.neo4j.visualization.graphviz.NodeStyle;
import org.neo4j.visualization.graphviz.RelationshipStyle;
import org.neo4j.visualization.graphviz.StyleParameter;

public class GraphStyle {
    final NodeStyle nodeStyle;
    final RelationshipStyle edgeStyle;
    private final DefaultStyleConfiguration configuration;
    private static volatile Header header;

    GraphStyle(StyleParameter ... parameters) {
        this.configuration = new DefaultStyleConfiguration(parameters);
        this.nodeStyle = new DefaultNodeStyle(this.configuration);
        this.edgeStyle = new DefaultRelationshipStyle(this.configuration);
    }

    public GraphStyle(NodeStyle nodeStyle, RelationshipStyle edgeStyle) {
        this.configuration = null;
        this.nodeStyle = nodeStyle;
        this.edgeStyle = edgeStyle;
    }

    protected void emitGraphEnd(Appendable stream) throws IOException {
        stream.append("}\n");
    }

    protected void emitGraphStart(Appendable stream) throws IOException {
        stream.append("digraph Neo {\n");
        this.emitHeaders(stream);
    }

    protected void emitHeaders(Appendable stream) throws IOException {
        if (this.configuration != null) {
            this.configuration.emitHeader(stream);
        }
        stream.append("  node [\n");
        if (this.configuration != null) {
            this.configuration.emitHeaderNode(stream);
        } else {
            GraphStyle.header().emitNode(stream);
        }
        stream.append("  ]\n");
        stream.append("  edge [\n");
        if (this.configuration != null) {
            this.configuration.emitHeaderEdge(stream);
        } else {
            GraphStyle.header().emitEdge(stream);
        }
        stream.append("  ]\n");
    }

    GraphStyle getSubgraphStyle(final String subgraphName) {
        return new GraphStyle(this.nodeStyle, this.edgeStyle){

            @Override
            protected void emitGraphStart(Appendable stream) throws IOException {
                stream.append(String.format(" subgraph cluster_%s {", subgraphName));
            }

            @Override
            protected void emitGraphEnd(Appendable stream) throws IOException {
                stream.append(String.format(" label = \"%s\"\n }\n", subgraphName));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Header header() {
        Header instance = header;
        if (instance != null) return instance;
        Class<GraphStyle> clazz = GraphStyle.class;
        synchronized (GraphStyle.class) {
            instance = header;
            if (instance != null) return instance;
            header = instance = new Header();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    static void emitHeader(Appendable stream, Map<String, String> header) throws IOException {
        for (String key : header.keySet()) {
            stream.append("    " + key + " = \"" + header.get(key) + "\"\n");
        }
    }

    static final class Header {
        final Map<String, String> nodeHeader = new HashMap<String, String>();
        final Map<String, String> edgeHeader = new HashMap<String, String>();
        final Map<String, String> graphHeader = new HashMap<String, String>();

        private Header() {
            String prefix = this.getClass().getPackage().getName() + ".";
            String nodePrefix = prefix + "node.";
            String relPrefix = prefix + "relationship.";
            Properties properties = System.getProperties();
            for (Object obj : properties.keySet()) {
                try {
                    String property = (String)obj;
                    if (property.startsWith(nodePrefix)) {
                        this.nodeHeader.put(property.substring(nodePrefix.length()), (String)properties.get(property));
                        continue;
                    }
                    if (!property.startsWith(relPrefix)) continue;
                    this.edgeHeader.put(property.substring(relPrefix.length()), (String)properties.get(property));
                }
                catch (ClassCastException cce) {}
            }
            this.assertMember(this.nodeHeader, properties, prefix, "fontname", "Bitstream Vera Sans");
            this.assertMember(this.nodeHeader, properties, prefix, "fontsize", "8");
            this.assertMember(this.edgeHeader, properties, prefix, "fontname", "Bitstream Vera Sans");
            this.assertMember(this.edgeHeader, properties, prefix, "fontsize", "8");
            this.nodeHeader.put("shape", "Mrecord");
        }

        private void assertMember(Map<String, String> header, Properties properties, String prefix, String key, String def) {
            if (!header.containsKey(key)) {
                header.put(key, properties.getProperty(prefix + key, def));
            }
        }

        private void emitNode(Appendable stream) throws IOException {
            GraphStyle.emitHeader(stream, this.nodeHeader);
        }

        private void emitEdge(Appendable stream) throws IOException {
            GraphStyle.emitHeader(stream, this.edgeHeader);
        }
    }
}

