/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.visualization.graphviz.AsciiDocStyle;
import org.neo4j.visualization.graphviz.DefaultRelationshipStyle;
import org.neo4j.visualization.graphviz.DefaultStyleConfiguration;
import org.neo4j.visualization.graphviz.NodeStyle;
import org.neo4j.visualization.graphviz.RelationshipStyle;
import org.neo4j.visualization.graphviz.SimpleNodeStyle;
import org.neo4j.visualization.graphviz.color.AutoNodeColor;
import org.neo4j.visualization.graphviz.color.AutoRelationshipTypeColor;
import org.neo4j.visualization.graphviz.color.ColorMapper;

public class AsciiDocSimpleStyle
extends AsciiDocStyle {
    private AsciiDocSimpleStyle() {
        this(false, true);
    }

    private AsciiDocSimpleStyle(NodeStyle nodeStyle, RelationshipStyle edgeStyle) {
        super(nodeStyle, edgeStyle);
    }

    private AsciiDocSimpleStyle(boolean autoColoredNodes, boolean autoColoredRelationships) {
        super(new SimpleNodeStyle(AsciiDocSimpleStyle.defaultNodeConfig(autoColoredNodes)), new DefaultRelationshipStyle(AsciiDocSimpleStyle.defaultRelationshipConfig(autoColoredRelationships)));
    }

    private AsciiDocSimpleStyle(ColorMapper<RelationshipType> relationshipTypeColors, boolean autoColoredNodes) {
        super(new SimpleNodeStyle(AsciiDocSimpleStyle.defaultNodeConfig(autoColoredNodes)), new DefaultRelationshipStyle(new DefaultStyleConfiguration(AsciiDocStyle.SIMPLE_PROPERTY_STYLE, new AutoRelationshipTypeColor(relationshipTypeColors))));
    }

    private AsciiDocSimpleStyle(boolean autoColoredRelationships, ColorMapper<Node> nodeColors) {
        super(new SimpleNodeStyle(new DefaultStyleConfiguration(new AutoNodeColor(nodeColors))), new DefaultRelationshipStyle(AsciiDocSimpleStyle.defaultRelationshipConfig(autoColoredRelationships)));
    }

    private AsciiDocSimpleStyle(ColorMapper<Node> nodeColors, ColorMapper<RelationshipType> relationshipTypeColors) {
        super(new SimpleNodeStyle(new DefaultStyleConfiguration(new AutoNodeColor(nodeColors))), new DefaultRelationshipStyle(new DefaultStyleConfiguration(AsciiDocStyle.SIMPLE_PROPERTY_STYLE, new AutoRelationshipTypeColor(relationshipTypeColors))));
    }

    private static DefaultStyleConfiguration defaultRelationshipConfig(boolean autoColoredRelationships) {
        if (autoColoredRelationships) {
            return new DefaultStyleConfiguration(AsciiDocStyle.SIMPLE_PROPERTY_STYLE, new AutoRelationshipTypeColor());
        }
        return AsciiDocStyle.PLAIN_STYLE;
    }

    private static DefaultStyleConfiguration defaultNodeConfig(boolean autoColoredNodes) {
        if (autoColoredNodes) {
            return new DefaultStyleConfiguration(AsciiDocStyle.SIMPLE_PROPERTY_STYLE, new AutoNodeColor());
        }
        return AsciiDocStyle.PLAIN_STYLE;
    }

    public static AsciiDocSimpleStyle withoutColors() {
        return new AsciiDocSimpleStyle(false, false);
    }

    public static AsciiDocSimpleStyle withAutomaticRelationshipTypeColors() {
        return new AsciiDocSimpleStyle(false, true);
    }

    public static AsciiDocSimpleStyle withAutomaticNodeColors() {
        return new AsciiDocSimpleStyle(true, false);
    }

    public static AsciiDocSimpleStyle withAutomaticNodeAndRelationshipTypeColors() {
        return new AsciiDocSimpleStyle(true, true);
    }

    public static AsciiDocSimpleStyle withPredefinedRelationshipTypeColors(ColorMapper<RelationshipType> relationshipTypeColors) {
        return new AsciiDocSimpleStyle(relationshipTypeColors, false);
    }

    public static AsciiDocSimpleStyle withAudomaticNodeAndPredefinedRelationshipTypeColors(ColorMapper<RelationshipType> relationshipTypeColors) {
        return new AsciiDocSimpleStyle(relationshipTypeColors, true);
    }

    public static AsciiDocSimpleStyle withPredefinedNodeColors(ColorMapper<Node> nodeColors) {
        return new AsciiDocSimpleStyle(false, nodeColors);
    }

    public static AsciiDocSimpleStyle withPredefinedNodeColorsAndAutomaticRelationshipTypeColors(ColorMapper<Node> nodeColors) {
        return new AsciiDocSimpleStyle(true, nodeColors);
    }

    public static AsciiDocSimpleStyle withPredefinedNodeAndRelationshipTypeColors(ColorMapper<Node> nodeColors, ColorMapper<RelationshipType> relationshipTypeColors) {
        return new AsciiDocSimpleStyle(nodeColors, relationshipTypeColors);
    }

    public static AsciiDocSimpleStyle withPredefinedNodeAndRelationshipStyles(NodeStyle nodeStyle, RelationshipStyle edgeStyle) {
        return new AsciiDocSimpleStyle(nodeStyle, edgeStyle);
    }
}

