/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.asciidoc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.visualization.graphviz.AsciiDocSimpleStyle;
import org.neo4j.visualization.graphviz.AsciiDocStyle;
import org.neo4j.visualization.graphviz.GraphStyle;
import org.neo4j.visualization.graphviz.GraphvizWriter;
import org.neo4j.walk.Walker;

public class AsciidocHelper {
    private static final int MAX_CHARS_PER_LINE = 100;
    private static final int MAX_TEXT_LINE_LENGTH = 80;
    private static final String ILLEGAL_STRINGS = "[:\\(\\)\t;&/\\\\]";

    public static String createGraphViz(String title, GraphDatabaseService graph, String identifier) {
        return AsciidocHelper.createGraphViz(title, graph, identifier, AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors());
    }

    public static String createGraphViz(String title, GraphDatabaseService graph, String identifier, String graphvizOptions) {
        return AsciidocHelper.createGraphViz(title, graph, identifier, AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors(), graphvizOptions);
    }

    public static String createGraphVizWithNodeId(String title, GraphDatabaseService graph, String identifier) {
        return AsciidocHelper.createGraphViz(title, graph, identifier, AsciiDocStyle.withAutomaticRelationshipTypeColors());
    }

    public static String createGraphVizWithNodeId(String title, GraphDatabaseService graph, String identifier, String graphvizOptions) {
        return AsciidocHelper.createGraphViz(title, graph, identifier, AsciiDocStyle.withAutomaticRelationshipTypeColors(), graphvizOptions);
    }

    public static String createGraphVizDeletingReferenceNode(String title, GraphDatabaseService graph, String identifier) {
        return AsciidocHelper.createGraphVizDeletingReferenceNode(title, graph, identifier, "");
    }

    public static String createGraphVizDeletingReferenceNode(String title, GraphDatabaseService graph, String identifier, String graphvizOptions) {
        return AsciidocHelper.createGraphViz(title, graph, identifier, AsciiDocSimpleStyle.withAutomaticRelationshipTypeColors(), graphvizOptions);
    }

    public static String createGraphVizWithNodeIdDeletingReferenceNode(String title, GraphDatabaseService graph, String identifier) {
        return AsciidocHelper.createGraphVizWithNodeIdDeletingReferenceNode(title, graph, identifier, "");
    }

    public static String createGraphVizWithNodeIdDeletingReferenceNode(String title, GraphDatabaseService graph, String identifier, String graphvizOptions) {
        return AsciidocHelper.createGraphViz(title, graph, identifier, AsciiDocStyle.withAutomaticRelationshipTypeColors(), graphvizOptions);
    }

    public static String createGraphViz(String title, GraphDatabaseService graph, String identifier, GraphStyle graphStyle) {
        return AsciidocHelper.createGraphViz(title, graph, identifier, graphStyle, "");
    }

    public static String createGraphViz(String title, GraphDatabaseService graph, String identifier, GraphStyle graphStyle, String graphvizOptions) {
        Throwable throwable = null;
        try (Transaction tx = graph.beginTx();){
            GraphvizWriter writer = new GraphvizWriter(graphStyle);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                writer.emit(out, Walker.fullGraph(graph));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String safeTitle = title.replaceAll(ILLEGAL_STRINGS, "");
            tx.success();
            try {
                String string = "." + title + "\n[\"dot\", \"" + (safeTitle + "-" + identifier).replace(" ", "-") + ".svg\", \"neoviz\", \"" + graphvizOptions + "\"]\n----\n" + out.toString(StandardCharsets.UTF_8.name()) + "----\n";
                return string;
            }
            catch (UnsupportedEncodingException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    public static String createOutputSnippet(String output) {
        return "[source]\n----\n" + output + "\n----\n";
    }

    public static String createQueryResultSnippet(String output) {
        return "[queryresult]\n----\n" + output + (output.endsWith("\n") ? "" : "\n") + "----\n";
    }

    public static String createQueryFailureSnippet(String output) {
        return "[source]\n----\n" + AsciidocHelper.wrapText(output) + "\n----\n";
    }

    private static String wrapText(String text) {
        return AsciidocHelper.wrap(text, 80, " ", "\n");
    }

    static String wrapQuery(String query) {
        String wrapped = AsciidocHelper.wrap(query, 100, ", ", ",\n  ");
        wrapped = AsciidocHelper.wrap(wrapped, 100, "),(", "),\n  (");
        return AsciidocHelper.wrap(wrapped, 100, " ", "\n  ");
    }

    private static String wrap(String text, int maxChars, String search, String replace) {
        StringBuffer out = new StringBuffer(text.length() + 10 * replace.length());
        String pattern = Pattern.quote(search);
        for (String line : text.trim().split("\n")) {
            if (line.length() < maxChars) {
                out.append(line).append('\n');
                continue;
            }
            int currentLength = 0;
            for (String word : line.split(pattern)) {
                if (currentLength + word.length() > maxChars) {
                    if (currentLength > 0) {
                        out.append(replace);
                    }
                    out.append(word);
                    currentLength = replace.length() + word.length();
                    continue;
                }
                if (currentLength != 0) {
                    out.append(search);
                    currentLength += search.length();
                }
                out.append(word);
                currentLength += word.length();
            }
            out.append('\n');
        }
        return out.substring(0, out.length() - 1);
    }

    public static String createCypherSnippet(String query) {
        String[] keywordsToBreakOn = new String[]{"start", "create", "unique", "set", "delete", "foreach", "match", "where", "with", "return", "skip", "limit", "order by", "asc", "ascending", "desc", "descending", "create", "remove", "drop", "using", "merge", "assert", "constraint"};
        String[] unbreakableKeywords = new String[]{"label", "values", "on", "index"};
        return AsciidocHelper.createLanguageSnippet(query, "cypher", keywordsToBreakOn, unbreakableKeywords);
    }

    public static String createSqlSnippet(String query) {
        return AsciidocHelper.createAsciiDocSnippet("sql", query);
    }

    private static String createLanguageSnippet(String query, String language, String[] keywordsToBreakOn, String[] unbreakableKeywords) {
        String formattedQuery;
        if ("cypher".equals(language) && query.contains("merge")) {
            formattedQuery = AsciidocHelper.uppercaseKeywords(query, keywordsToBreakOn);
            formattedQuery = AsciidocHelper.uppercaseKeywords(formattedQuery, unbreakableKeywords);
        } else {
            formattedQuery = AsciidocHelper.breakOnKeywords(query, keywordsToBreakOn);
            formattedQuery = AsciidocHelper.uppercaseKeywords(formattedQuery, unbreakableKeywords);
        }
        String result = AsciidocHelper.createAsciiDocSnippet(language, formattedQuery);
        return AsciidocHelper.limitChars(result);
    }

    public static String createCypherSnippetFromPreformattedQuery(String formattedQuery, boolean executable) {
        return AsciidocHelper.cypherSnippet(formattedQuery, executable ? "cypher" : "cypher-noexec");
    }

    private static String cypherSnippet(String formattedQuery, String lang) {
        return String.format("[source,%s]\n----\n%s%s----\n", lang, AsciidocHelper.wrapQuery(formattedQuery), formattedQuery.endsWith("\n") ? "" : "\n");
    }

    public static String createAsciiDocSnippet(String language, String formattedQuery) {
        return String.format("[source,%s]\n----\n%s%s----\n", language, formattedQuery, formattedQuery.endsWith("\n") ? "" : "\n");
    }

    private static String breakOnKeywords(String query, String[] keywordsToBreakOn) {
        String result = query;
        for (String keyword : keywordsToBreakOn) {
            String upperKeyword = keyword.toUpperCase();
            result = AsciidocHelper.ucaseIfFirstInLine(result, keyword, upperKeyword);
            result = result.replace(" " + upperKeyword + " ", "\n" + upperKeyword + " ");
        }
        return result;
    }

    private static String ucaseIfFirstInLine(String result, String keyword, String upperKeyword) {
        if (result.length() > keyword.length() && result.startsWith(keyword + " ")) {
            result = upperKeyword + " " + result.substring(keyword.length() + 1);
        }
        return result.replace("\n" + keyword, "\n" + upperKeyword);
    }

    private static String uppercaseKeywords(String query, String[] uppercaseKeywords) {
        String result = query;
        for (String keyword : uppercaseKeywords) {
            String upperKeyword = keyword.toUpperCase();
            result = AsciidocHelper.ucaseIfFirstInLine(result, keyword, upperKeyword);
            result = result.replace(" " + keyword + " ", " " + upperKeyword + " ");
        }
        return result;
    }

    private static String limitChars(String result) {
        String[] lines = result.split("\n");
        String finalRes = "";
        for (String line : lines) {
            if ((line = line.trim()).length() > 100) {
                line = line.replaceAll(", ", ",\n      ");
            }
            finalRes = finalRes + line + "\n";
        }
        return finalRes;
    }
}

