/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.ImpermanentDatabaseRule;
import org.neo4j.visualization.graphviz.GraphvizWriter;
import org.neo4j.visualization.graphviz.StyleParameter;
import org.neo4j.walk.Walker;

public class TestNewGraphvizWriter {
    @Rule
    public final DatabaseRule dbRule = new ImpermanentDatabaseRule();

    @Test
    public void testSimpleGraph() throws Exception {
        GraphDatabaseAPI neo = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = neo.beginTx();){
            Node emil = neo.createNode();
            emil.setProperty("name", (Object)"Emil Eifr\u00e9m");
            emil.setProperty("age", (Object)30);
            Node tobias = neo.createNode();
            tobias.setProperty("name", (Object)"Tobias \"thobe\" Ivarsson");
            tobias.setProperty("age", (Object)23);
            tobias.setProperty("hours", (Object)new int[]{10, 10, 4, 4, 0});
            Node johan = neo.createNode();
            johan.setProperty("!<>)", (Object)"!<>)");
            johan.setProperty("name", (Object)"!<>Johan '\\n00b' !<>Svensson");
            Relationship emilKNOWStobias = emil.createRelationshipTo(tobias, (RelationshipType)type.KNOWS);
            emilKNOWStobias.setProperty("since", (Object)"2003-08-17");
            Relationship johanKNOWSemil = johan.createRelationshipTo(emil, (RelationshipType)type.KNOWS);
            Relationship tobiasKNOWSjohan = tobias.createRelationshipTo(johan, (RelationshipType)type.KNOWS);
            Relationship tobiasWORKS_FORemil = tobias.createRelationshipTo(emil, (RelationshipType)type.WORKS_FOR);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GraphvizWriter writer = new GraphvizWriter(new StyleParameter[0]);
            ResourceIterable traverser = this.dbRule.traversalDescription().depthFirst().relationships((RelationshipType)type.KNOWS).relationships((RelationshipType)type.WORKS_FOR).traverse(emil).nodes();
            writer.emit((OutputStream)out, Walker.crosscut((Iterable)traverser, (RelationshipType[])new RelationshipType[]{type.KNOWS, type.WORKS_FOR}));
            tx.success();
            ((Object)out).toString();
        }
    }

    static enum type implements RelationshipType
    {
        KNOWS,
        WORKS_FOR;

    }
}

