/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.visualization.PropertyType;
import org.neo4j.visualization.graphviz.ParameterGetter;
import org.neo4j.visualization.graphviz.PropertyFilter;
import org.neo4j.visualization.graphviz.PropertyFormatter;
import org.neo4j.visualization.graphviz.StyleConfiguration;
import org.neo4j.visualization.graphviz.TitleGetter;

public interface StyleParameter {
    public void configure(StyleConfiguration var1);

    public static enum Simple implements StyleParameter
    {
        NO_RELATIONSHIP_PROPERTIES{

            @Override
            public final void configure(StyleConfiguration configuration) {
                configuration.setRelationshipPropertyFilter(key -> false);
            }
        }
        ,
        NO_RELATIONSHIP_LABEL{

            @Override
            public final void configure(StyleConfiguration configuration) {
                configuration.displayRelationshipLabel(false);
            }
        }
        ,
        PROPERTY_AS_KEY_EQUALS_VALUE_COLON_TYPE{

            @Override
            public final void configure(StyleConfiguration configuration) {
                PropertyFormatter format = (key, type, value) -> configuration.escapeLabel(key) + " = " + configuration.escapeLabel(PropertyType.format(value)) + " : " + type.typeName;
                configuration.setNodePropertyFomatter(format);
                configuration.setRelationshipPropertyFomatter(format);
            }
        }
        ,
        PROPERTY_AS_KEY_EQUALS_VALUE{

            @Override
            public final void configure(StyleConfiguration configuration) {
                PropertyFormatter format = (key, type, value) -> configuration.escapeLabel(key) + " = " + configuration.escapeLabel(PropertyType.format(value));
                configuration.setNodePropertyFomatter(format);
                configuration.setRelationshipPropertyFomatter(format);
            }
        }
        ,
        PROPERTY_AS_KEY_COLON_TYPE{

            @Override
            public final void configure(StyleConfiguration configuration) {
                PropertyFormatter format = (key, type, value) -> configuration.escapeLabel(key) + " : " + type.typeName;
                configuration.setNodePropertyFomatter(format);
                configuration.setRelationshipPropertyFomatter(format);
            }
        };


        @Override
        public abstract void configure(StyleConfiguration var1);
    }

    public static abstract class RelationshipTailLabel
    implements StyleParameter {
        @Override
        public void configure(StyleConfiguration configuration) {
            configuration.setRelationshipParameterGetter("taillabel", (container, key) -> this.getTailLabel((Relationship)container));
        }

        protected abstract String getTailLabel(Relationship var1);
    }

    public static abstract class RelationshipHeadLabel
    implements StyleParameter {
        @Override
        public void configure(StyleConfiguration configuration) {
            configuration.setRelationshipParameterGetter("headlabel", (container, key) -> this.getHeadLabel((Relationship)container));
        }

        protected abstract String getHeadLabel(Relationship var1);
    }

    public static abstract class RelationshipPropertyFormat
    implements StyleParameter,
    PropertyFormatter {
        @Override
        public final void configure(StyleConfiguration configuration) {
            configuration.setRelationshipPropertyFomatter(this);
        }
    }

    public static abstract class NodePropertyFormat
    implements StyleParameter,
    PropertyFormatter {
        @Override
        public final void configure(StyleConfiguration configuration) {
            configuration.setNodePropertyFomatter(this);
        }
    }

    public static abstract class RelationshipPropertyFilter
    implements StyleParameter,
    PropertyFilter {
        @Override
        public final void configure(StyleConfiguration configuration) {
            configuration.setRelationshipPropertyFilter(this);
        }
    }

    public static abstract class NodePropertyFilter
    implements StyleParameter,
    PropertyFilter {
        @Override
        public final void configure(StyleConfiguration configuration) {
            configuration.setNodePropertyFilter(this);
        }
    }

    public static abstract class GenericRelationshipParameters
    implements StyleParameter,
    ParameterGetter<Relationship> {
        private final String[] keys;

        protected GenericRelationshipParameters(String ... keys) {
            this.keys = keys;
        }

        @Override
        public final void configure(StyleConfiguration configuration) {
            for (String key : this.keys) {
                configuration.setRelationshipParameterGetter(key, this);
            }
        }
    }

    public static abstract class GenericNodeParameters
    implements StyleParameter,
    ParameterGetter<Node> {
        private final Iterable<String> keys;

        protected GenericNodeParameters(String ... keys) {
            this.keys = Arrays.asList(keys);
        }

        @Override
        public final void configure(StyleConfiguration configuration) {
            for (String key : this.keys) {
                configuration.setNodeParameterGetter(key, this);
            }
        }
    }

    public static final class RelationshipTitleProperty
    extends RelationshipTitle {
        private final String key;

        public RelationshipTitleProperty(String key) {
            this.key = key;
        }

        @Override
        public String getTitle(Relationship relationship) {
            return (String)relationship.getProperty(this.key);
        }
    }

    public static final class NodeTitleProperty
    extends NodeTitle {
        private final String key;

        public NodeTitleProperty(String key) {
            this.key = key;
        }

        @Override
        public String getTitle(Node node) {
            return (String)node.getProperty(this.key);
        }
    }

    public static abstract class RelationshipTitle
    implements StyleParameter,
    TitleGetter<Relationship> {
        @Override
        public final void configure(StyleConfiguration configuration) {
            configuration.setRelationshipTitleGetter(this);
        }
    }

    public static abstract class NodeTitle
    implements StyleParameter,
    TitleGetter<Node> {
        @Override
        public final void configure(StyleConfiguration configuration) {
            configuration.setNodeTitleGetter(this);
        }
    }

    public static final class ReverseOrderRelationshipTypes
    extends ReverseRelationshipOrder {
        private final Set<String> reversedTypes = new HashSet<String>();

        public ReverseOrderRelationshipTypes(RelationshipType ... types) {
            for (RelationshipType type : types) {
                this.reversedTypes.add(type.name());
            }
        }

        @Override
        protected boolean reversedOrder(Relationship edge) {
            return this.reversedTypes.contains(edge.getType().name());
        }
    }

    public static abstract class ReverseRelationshipOrder
    implements StyleParameter {
        @Override
        public void configure(StyleConfiguration configuration) {
            configuration.setRelationshipReverseOrderPredicate(item -> this.reversedOrder((Relationship)item));
        }

        protected abstract boolean reversedOrder(Relationship var1);
    }

    public static abstract class NodeColor
    implements StyleParameter {
        @Override
        public final void configure(StyleConfiguration configuration) {
            ParameterGetter<Node> getter = (node, key) -> {
                if (key.equals("color")) {
                    return this.getColor((Node)node);
                }
                if (key.equals("fontcolor")) {
                    return this.getFontColor((Node)node);
                }
                return this.getFillColor((Node)node);
            };
            configuration.setDefaultNodeProperty("style", "filled");
            configuration.setNodeParameterGetter("color", getter);
            configuration.setNodeParameterGetter("fillcolor", getter);
            configuration.setNodeParameterGetter("fontcolor", getter);
        }

        protected String getFontColor(Node node) {
            return this.getColor(node);
        }

        protected abstract String getColor(Node var1);

        protected String getFillColor(Node node) {
            return null;
        }
    }

    public static abstract class RelationshipTypeColor
    extends RelationshipColor {
        private final Map<String, String> colors = new HashMap<String, String>();
        private final Map<String, String> fontColors = new HashMap<String, String>();

        @Override
        protected final String getColor(Relationship relationship) {
            RelationshipType type = relationship.getType();
            String result = this.colors.get(type.name());
            if (result == null) {
                result = this.getColor(type);
                if (result == null) {
                    result = "black";
                }
                this.colors.put(type.name(), result);
            }
            return result;
        }

        @Override
        protected final String getFontColor(Relationship relationship) {
            RelationshipType type = relationship.getType();
            String result = this.fontColors.get(type.name());
            if (result == null) {
                result = this.getFontColor(type);
                if (result == null) {
                    result = "black";
                }
                this.fontColors.put(type.name(), result);
            }
            return result;
        }

        protected String getFontColor(RelationshipType type) {
            return this.getColor(type);
        }

        protected abstract String getColor(RelationshipType var1);
    }

    public static abstract class RelationshipColor
    implements StyleParameter {
        @Override
        public final void configure(StyleConfiguration configuration) {
            ParameterGetter<Relationship> getter = (relationship, key) -> {
                if (key.equals("color")) {
                    return this.getColor((Relationship)relationship);
                }
                return this.getFontColor((Relationship)relationship);
            };
            configuration.setRelationshipParameterGetter("color", getter);
            configuration.setRelationshipParameterGetter("fontcolor", getter);
        }

        protected String getFontColor(Relationship relationship) {
            return this.getColor(relationship);
        }

        protected abstract String getColor(Relationship var1);
    }

    public static final class DefaultRelationshipProperty
    implements StyleParameter {
        private final String property;
        private final String value;

        public DefaultRelationshipProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        @Override
        public final void configure(StyleConfiguration configuration) {
            configuration.setDefaultRelationshipProperty(this.property, this.value);
        }
    }

    public static final class DefaultNodeProperty
    implements StyleParameter {
        private final String property;
        private final String value;

        public DefaultNodeProperty(String property, String value) {
            this.property = property;
            this.value = value;
        }

        @Override
        public final void configure(StyleConfiguration configuration) {
            configuration.setDefaultNodeProperty(this.property, this.value);
        }
    }

    public static final class RelationshipFont
    implements StyleParameter {
        private final String name;
        private final int size;

        public RelationshipFont(String fontName, int fontSize) {
            this.name = fontName;
            this.size = fontSize;
        }

        @Override
        public final void configure(StyleConfiguration configuration) {
            configuration.setDefaultRelationshipProperty("fontname", this.name);
            configuration.setDefaultRelationshipProperty("fontsize", Integer.toString(this.size));
        }
    }

    public static final class NodeFont
    implements StyleParameter {
        private final String name;
        private final int size;

        public NodeFont(String fontName, int fontSize) {
            this.name = fontName;
            this.size = fontSize;
        }

        @Override
        public final void configure(StyleConfiguration configuration) {
            configuration.setDefaultNodeProperty("fontname", this.name);
            configuration.setDefaultNodeProperty("fontsize", Integer.toString(this.size));
        }
    }

    public static final class GraphLabel
    implements StyleParameter {
        private final String label;

        public GraphLabel(String label) {
            this.label = label;
        }

        @Override
        public void configure(StyleConfiguration configuration) {
            configuration.setGraphProperty("label", configuration.escapeLabel(this.label));
        }
    }
}

