/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.visualization.graphviz;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.neo4j.visualization.Visualizer;
import org.neo4j.visualization.graphviz.GraphStyle;
import org.neo4j.visualization.graphviz.GraphvizRenderer;
import org.neo4j.visualization.graphviz.StyleParameter;
import org.neo4j.walk.Walker;

public final class GraphvizWriter {
    private final GraphStyle style;

    public GraphvizWriter(StyleParameter ... configuration) {
        this(new GraphStyle(configuration));
    }

    public GraphvizWriter(GraphStyle style) {
        this.style = style;
    }

    public void emit(File dest, Walker walker) throws IOException {
        FileOutputStream stream = new FileOutputStream(dest);
        this.emit(stream, walker);
        ((OutputStream)stream).close();
    }

    public void emit(OutputStream outputStream, Walker walker) throws IOException {
        if (outputStream instanceof PrintStream) {
            this.emit(walker, new GraphvizRenderer(this.style, (PrintStream)outputStream));
        } else {
            this.emit(walker, new GraphvizRenderer(this.style, new PrintStream(outputStream, true, StandardCharsets.UTF_8.name())));
        }
    }

    private void emit(Walker walker, GraphvizRenderer renderer) throws IOException {
        walker.accept(new Visualizer<IOException>(renderer));
    }
}

