/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class LuceneFulltextDocumentStructure {
    public static final String FIELD_ENTITY_ID = "__neo4j__lucene__fulltext__index__internal__id__";
    private static final ThreadLocal<DocWithId> perThreadDocument = ThreadLocal.withInitial(() -> new DocWithId());

    private LuceneFulltextDocumentStructure() {
    }

    private static DocWithId reuseDocument(long id) {
        DocWithId doc = perThreadDocument.get();
        doc.setId(id);
        return doc;
    }

    public static Document documentRepresentingProperties(long id, Collection<String> propertyNames, Value[] values) {
        DocWithId document = LuceneFulltextDocumentStructure.reuseDocument(id);
        document.setValues(propertyNames, values);
        return document.document;
    }

    private static Field encodeValueField(String propertyKey, Value value) {
        TextValue textValue = (TextValue)value;
        String stringValue = textValue.stringValue();
        return new TextField(propertyKey, stringValue, Field.Store.NO);
    }

    static long getNodeId(Document from) {
        String entityId = from.get(FIELD_ENTITY_ID);
        return Long.parseLong(entityId);
    }

    static Term newTermForChangeOrRemove(long id) {
        return new Term(FIELD_ENTITY_ID, "" + id);
    }

    static Query newCountNodeEntriesQuery(long nodeId, String[] propertyKeys, Value ... propertyValues) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add((Query)new TermQuery(LuceneFulltextDocumentStructure.newTermForChangeOrRemove(nodeId)), BooleanClause.Occur.MUST);
        for (int i = 0; i < propertyKeys.length; ++i) {
            String propertyKey = propertyKeys[i];
            Value value = propertyValues[i];
            if (value.valueGroup() != ValueGroup.TEXT) continue;
            ConstantScoreQuery valueQuery = new ConstantScoreQuery((Query)new TermQuery(new Term(propertyKey, value.asObject().toString())));
            builder.add((Query)valueQuery, BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    private static class DocWithId {
        private final Document document;
        private final Field idField = new StringField("__neo4j__lucene__fulltext__index__internal__id__", "", Field.Store.YES);
        private final Field idValueField = new NumericDocValuesField("__neo4j__lucene__fulltext__index__internal__id__", 0L);

        private DocWithId() {
            this.document = new Document();
            this.document.add((IndexableField)this.idField);
            this.document.add((IndexableField)this.idValueField);
        }

        private void setId(long id) {
            this.removeAllValueFields();
            this.idField.setStringValue(Long.toString(id));
            this.idValueField.setLongValue(id);
        }

        private void setValues(Collection<String> names, Value[] values) {
            int i = 0;
            for (String name : names) {
                Value value;
                if ((value = values[i++]) == null || value.valueGroup() != ValueGroup.TEXT) continue;
                Field field = LuceneFulltextDocumentStructure.encodeValueField(name, value);
                this.document.add((IndexableField)field);
            }
        }

        private void removeAllValueFields() {
            Iterator it = this.document.getFields().iterator();
            while (it.hasNext()) {
                IndexableField field = (IndexableField)it.next();
                String fieldName = field.name();
                if (fieldName.equals(LuceneFulltextDocumentStructure.FIELD_ENTITY_ID)) continue;
                it.remove();
            }
        }
    }
}

