/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Arrays;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.impl.fulltext.ScoreEntityIterator;

public class ScoreEntityIteratorTest {
    @Test
    public void mergeShouldReturnOrderedResults() {
        ScoreEntityIterator one = ScoreEntityIteratorTest.iteratorOf(new ScoreEntityIterator.ScoreEntry[]{ScoreEntityIteratorTest.entry(3L, 10.0f), ScoreEntityIteratorTest.entry(10L, 3.0f), ScoreEntityIteratorTest.entry(12L, 1.0f)});
        ScoreEntityIterator two = ScoreEntityIteratorTest.iteratorOf(new ScoreEntityIterator.ScoreEntry[]{ScoreEntityIteratorTest.entry(1L, 12.0f), ScoreEntityIteratorTest.entry(5L, 8.0f), ScoreEntityIteratorTest.entry(7L, 6.0f), ScoreEntityIteratorTest.entry(8L, 5.0f), ScoreEntityIteratorTest.entry(11L, 2.0f)});
        ScoreEntityIterator three = ScoreEntityIteratorTest.iteratorOf(new ScoreEntityIterator.ScoreEntry[]{ScoreEntityIteratorTest.entry(2L, 11.0f), ScoreEntityIteratorTest.entry(4L, 9.0f), ScoreEntityIteratorTest.entry(6L, 7.0f), ScoreEntityIteratorTest.entry(9L, 4.0f)});
        ScoreEntityIterator concat = ScoreEntityIterator.mergeIterators(Arrays.asList(one, two, three));
        for (int i = 1; i <= 12; ++i) {
            Assert.assertTrue((boolean)concat.hasNext());
            ScoreEntityIterator.ScoreEntry entry = concat.next();
            Assert.assertEquals((long)i, (long)entry.entityId());
            Assert.assertEquals((double)(13 - i), (double)entry.score(), (double)0.001);
        }
        Assert.assertFalse((boolean)concat.hasNext());
    }

    private static ScoreEntityIterator.ScoreEntry entry(long id, float s) {
        return new ScoreEntityIterator.ScoreEntry(id, s);
    }

    @Test
    public void mergeShouldHandleEmptyIterators() {
        ScoreEntityIterator one = ScoreEntityIteratorTest.iteratorOf(ScoreEntityIteratorTest.emptyEntries());
        ScoreEntityIterator two = ScoreEntityIteratorTest.iteratorOf(new ScoreEntityIterator.ScoreEntry[]{ScoreEntityIteratorTest.entry(1L, 5.0f), ScoreEntityIteratorTest.entry(2L, 4.0f), ScoreEntityIteratorTest.entry(3L, 3.0f), ScoreEntityIteratorTest.entry(4L, 2.0f), ScoreEntityIteratorTest.entry(5L, 1.0f)});
        ScoreEntityIterator three = ScoreEntityIteratorTest.iteratorOf(ScoreEntityIteratorTest.emptyEntries());
        ScoreEntityIterator concat = ScoreEntityIterator.mergeIterators(Arrays.asList(one, two, three));
        for (int i = 1; i <= 5; ++i) {
            Assert.assertTrue((boolean)concat.hasNext());
            ScoreEntityIterator.ScoreEntry entry = concat.next();
            Assert.assertEquals((long)i, (long)entry.entityId());
            Assert.assertEquals((double)(6 - i), (double)entry.score(), (double)0.001);
        }
        Assert.assertFalse((boolean)concat.hasNext());
    }

    @Test
    public void mergeShouldHandleAllEmptyIterators() {
        ScoreEntityIterator one = ScoreEntityIteratorTest.iteratorOf(ScoreEntityIteratorTest.emptyEntries());
        ScoreEntityIterator two = ScoreEntityIteratorTest.iteratorOf(ScoreEntityIteratorTest.emptyEntries());
        ScoreEntityIterator three = ScoreEntityIteratorTest.iteratorOf(ScoreEntityIteratorTest.emptyEntries());
        ScoreEntityIterator concat = ScoreEntityIterator.mergeIterators(Arrays.asList(one, two, three));
        Assert.assertFalse((boolean)concat.hasNext());
    }

    private static ScoreEntityIterator.ScoreEntry[] emptyEntries() {
        return new ScoreEntityIterator.ScoreEntry[0];
    }

    private static ScoreEntityIterator iteratorOf(final ScoreEntityIterator.ScoreEntry[] input) {
        return new ScoreEntityIterator(null){
            Iterator<ScoreEntityIterator.ScoreEntry> entries;
            {
                super(x0);
                this.entries = Arrays.asList(input).iterator();
            }

            public boolean hasNext() {
                return this.entries.hasNext();
            }

            public ScoreEntityIterator.ScoreEntry next() {
                return this.entries.next();
            }
        };
    }
}

