/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext.integrations.bloom;

import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexType;
import org.neo4j.kernel.api.impl.fulltext.FulltextProvider;
import org.neo4j.kernel.api.impl.fulltext.ReadOnlyFulltext;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class BloomProcedures {
    @Context
    public FulltextProvider provider;

    @Description(value="Await the completion of any background index population or updates")
    @Procedure(name="bloom.awaitPopulation", mode=Mode.READ)
    public void awaitPopulation() throws Exception {
        this.provider.awaitPopulation();
    }

    @Description(value="Returns the node property keys indexed by the Bloom fulltext index add-on")
    @Procedure(name="bloom.getIndexedNodePropertyKeys", mode=Mode.READ)
    public Stream<PropertyOutput> getIndexedNodePropertyKeys() throws Exception {
        return this.provider.getProperties("bloomNodes", FulltextIndexType.NODES).stream().map(PropertyOutput::new);
    }

    @Description(value="Returns the relationship property keys indexed by the Bloom fulltext index add-on")
    @Procedure(name="bloom.getIndexedRelationshipPropertyKeys", mode=Mode.READ)
    public Stream<PropertyOutput> getIndexedRelationshipPropertyKeys() throws Exception {
        return this.provider.getProperties("bloomNodes", FulltextIndexType.NODES).stream().map(PropertyOutput::new);
    }

    @Description(value="Set the node property keys to index")
    @Procedure(name="bloom.setIndexedNodePropertyKeys", mode=Mode.SCHEMA)
    public void setIndexedNodePropertyKeys(@Name(value="propertyKeys") List<String> propertyKeys) throws Exception {
        this.provider.changeIndexedProperties("bloomNodes", FulltextIndexType.NODES, propertyKeys);
    }

    @Description(value="Set the relationship property keys to index")
    @Procedure(name="bloom.setIndexedRelationshipPropertyKeys", mode=Mode.SCHEMA)
    public void setIndexedRelationshipPropertyKeys(@Name(value="propertyKeys") List<String> propertyKeys) throws Exception {
        this.provider.changeIndexedProperties("bloomRelationships", FulltextIndexType.RELATIONSHIPS, propertyKeys);
    }

    @Description(value="Check the status of the Bloom fulltext index add-on")
    @Procedure(name="bloom.indexStatus", mode=Mode.READ)
    public Stream<StatusOutput> indexStatus() throws Exception {
        InternalIndexState nodeIndexState = this.provider.getState("bloomNodes", FulltextIndexType.NODES);
        InternalIndexState relationshipIndexState = this.provider.getState("bloomRelationships", FulltextIndexType.RELATIONSHIPS);
        return Stream.of(nodeIndexState, relationshipIndexState).map(x$0 -> new StatusOutput((InternalIndexState)x$0));
    }

    @Description(value="Query the Bloom fulltext index for nodes")
    @Procedure(name="bloom.searchNodes", mode=Mode.READ)
    public Stream<EntityOutput> bloomFulltextNodes(@Name(value="terms") List<String> terms, @Name(value="fuzzy", defaultValue="true") boolean fuzzy, @Name(value="matchAll", defaultValue="false") boolean matchAll) throws Exception {
        try (ReadOnlyFulltext indexReader = this.provider.getReader("bloomNodes", FulltextIndexType.NODES);){
            Stream<EntityOutput> stream = this.queryAsStream(terms, indexReader, fuzzy, matchAll);
            return stream;
        }
    }

    @Description(value="Query the Bloom fulltext index for relationships")
    @Procedure(name="bloom.searchRelationships", mode=Mode.READ)
    public Stream<EntityOutput> bloomFulltextRelationships(@Name(value="terms") List<String> terms, @Name(value="fuzzy", defaultValue="true") boolean fuzzy, @Name(value="matchAll", defaultValue="false") boolean matchAll) throws Exception {
        try (ReadOnlyFulltext indexReader = this.provider.getReader("bloomRelationships", FulltextIndexType.RELATIONSHIPS);){
            Stream<EntityOutput> stream = this.queryAsStream(terms, indexReader, fuzzy, matchAll);
            return stream;
        }
    }

    private Stream<EntityOutput> queryAsStream(List<String> terms, ReadOnlyFulltext indexReader, boolean fuzzy, boolean matchAll) {
        PrimitiveLongIterator primitiveLongIterator = fuzzy ? indexReader.fuzzyQuery(terms, matchAll) : indexReader.query(terms, matchAll);
        Iterator iterator = PrimitiveLongCollections.map(EntityOutput::new, (PrimitiveLongIterator)primitiveLongIterator);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public class StatusOutput {
        public final String state;

        public StatusOutput(InternalIndexState internalIndexState) {
            switch (internalIndexState) {
                case POPULATING: {
                    this.state = "POPULATING";
                    break;
                }
                case ONLINE: {
                    this.state = "ONLINE";
                    break;
                }
                case FAILED: {
                    this.state = "FAILED";
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Illegal index state %s", internalIndexState));
                }
            }
        }
    }

    public static class PropertyOutput {
        public final String propertyKey;

        public PropertyOutput(String propertykey) {
            this.propertyKey = propertykey;
        }
    }

    public static class EntityOutput {
        public final long entityid;

        public EntityOutput(long entityid) {
            this.entityid = entityid;
        }
    }
}

