/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext.integrations.bloom;

import java.io.File;
import java.util.function.Supplier;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.impl.fulltext.integrations.bloom.BloomKernelExtension;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.scheduler.JobScheduler;

public class BloomKernelExtensionFactory
extends KernelExtensionFactory<Dependencies> {
    public static final String SERVICE_NAME = "bloom";
    public static final String BLOOM_RELATIONSHIPS = "bloomRelationships";
    public static final String BLOOM_NODES = "bloomNodes";

    public BloomKernelExtensionFactory() {
        super(SERVICE_NAME);
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        FileSystemAbstraction fs = dependencies.fileSystem();
        File storeDir = context.storeDir();
        Config config = dependencies.getConfig();
        GraphDatabaseService db = dependencies.db();
        Procedures procedures = dependencies.procedures();
        LogService logService = dependencies.logService();
        AvailabilityGuard availabilityGuard = dependencies.availabilityGuard();
        JobScheduler scheduler = dependencies.scheduler();
        Supplier<TransactionIdStore> transactionIdStore = dependencies::transactionIdStore;
        return new BloomKernelExtension(fs, storeDir, config, db, procedures, logService, availabilityGuard, scheduler, transactionIdStore);
    }

    public static interface Dependencies {
        public Config getConfig();

        public GraphDatabaseService db();

        public FileSystemAbstraction fileSystem();

        public Procedures procedures();

        public LogService logService();

        public AvailabilityGuard availabilityGuard();

        public JobScheduler scheduler();

        public TransactionIdStore transactionIdStore();
    }
}

