/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext.integrations.bloom;

import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexType;
import org.neo4j.kernel.api.impl.fulltext.FulltextProvider;
import org.neo4j.kernel.api.impl.fulltext.FulltextProviderImpl;
import org.neo4j.kernel.api.impl.fulltext.integrations.bloom.BloomFulltextConfig;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;

class BloomKernelExtension
extends LifecycleAdapter {
    private final File storeDir;
    private final Config config;
    private final FileSystemAbstraction fileSystem;
    private final GraphDatabaseService db;
    private final Procedures procedures;
    private LogService logService;
    private final AvailabilityGuard availabilityGuard;
    private final JobScheduler scheduler;
    private final Supplier<TransactionIdStore> transactionIdStore;
    private FulltextProvider provider;

    BloomKernelExtension(FileSystemAbstraction fileSystem, File storeDir, Config config, GraphDatabaseService db, Procedures procedures, LogService logService, AvailabilityGuard availabilityGuard, JobScheduler scheduler, Supplier<TransactionIdStore> transactionIdStore) {
        this.storeDir = storeDir;
        this.config = config;
        this.fileSystem = fileSystem;
        this.db = db;
        this.procedures = procedures;
        this.logService = logService;
        this.availabilityGuard = availabilityGuard;
        this.scheduler = scheduler;
        this.transactionIdStore = transactionIdStore;
    }

    public void start() throws IOException, KernelException {
        if (((Boolean)this.config.get(BloomFulltextConfig.bloom_enabled)).booleanValue()) {
            String analyzer = (String)this.config.get(BloomFulltextConfig.bloom_default_analyzer);
            Log log = this.logService.getInternalLog(FulltextProviderImpl.class);
            this.provider = new FulltextProviderImpl(this.db, log, this.availabilityGuard, this.scheduler, this.transactionIdStore.get(), this.fileSystem, this.storeDir, analyzer);
            this.provider.openIndex("bloomNodes", FulltextIndexType.NODES);
            this.provider.openIndex("bloomRelationships", FulltextIndexType.RELATIONSHIPS);
            this.provider.registerTransactionEventHandler();
            this.procedures.registerComponent(FulltextProvider.class, context -> this.provider, true);
        } else {
            this.procedures.registerComponent(FulltextProvider.class, context -> FulltextProvider.NULL_PROVIDER, true);
        }
    }

    public void stop() throws Exception {
        if (this.provider != null) {
            this.provider.close();
        }
    }
}

