/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.Set;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltext;
import org.neo4j.kernel.api.impl.fulltext.ReadOnlyFulltext;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.WritableAbstractDatabaseIndex;
import org.neo4j.kernel.api.impl.schema.writer.PartitionedIndexWriter;
import org.neo4j.kernel.api.index.InternalIndexState;

class WritableFulltext
extends WritableAbstractDatabaseIndex<LuceneFulltext> {
    private PartitionedIndexWriter indexWriter;

    WritableFulltext(LuceneFulltext luceneFulltext) throws IOException {
        super((AbstractLuceneIndex)luceneFulltext);
    }

    public void open() throws IOException {
        super.open();
        this.indexWriter = ((LuceneFulltext)this.luceneIndex).getIndexWriter(this);
    }

    public void close() throws IOException {
        super.close();
        this.indexWriter = null;
    }

    public void drop() throws IOException {
        super.drop();
        this.indexWriter = null;
    }

    PartitionedIndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    Set<String> getProperties() {
        return ((LuceneFulltext)this.luceneIndex).getProperties();
    }

    void setPopulated() {
        ((LuceneFulltext)this.luceneIndex).setPopulated();
    }

    void setFailed() {
        ((LuceneFulltext)this.luceneIndex).setFailed();
    }

    ReadOnlyFulltext getIndexReader() throws IOException {
        return ((LuceneFulltext)this.luceneIndex).getIndexReader();
    }

    String getAnalyzerName() {
        return ((LuceneFulltext)this.luceneIndex).getAnalyzerName();
    }

    void saveConfiguration(long lastCommittedTransactionId) throws IOException {
        ((LuceneFulltext)this.luceneIndex).saveConfiguration(lastCommittedTransactionId);
    }

    InternalIndexState getState() {
        return ((LuceneFulltext)this.luceneIndex).getState();
    }
}

