/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexConfiguration;
import org.neo4j.kernel.api.impl.fulltext.ReadOnlyFulltext;
import org.neo4j.kernel.api.impl.index.collector.DocValuesCollector;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;

class SimpleFulltextReader
implements ReadOnlyFulltext {
    private final PartitionSearcher partitionSearcher;
    private final Analyzer analyzer;
    private final String[] properties;

    SimpleFulltextReader(PartitionSearcher partitionSearcher, String[] properties, Analyzer analyzer) {
        this.partitionSearcher = partitionSearcher;
        this.properties = properties;
        this.analyzer = analyzer;
    }

    @Override
    public PrimitiveLongIterator query(Collection<String> terms, boolean matchAll) {
        String query = terms.stream().map(QueryParserBase::escape).collect(Collectors.joining(" "));
        return this.innerQuery(query, matchAll);
    }

    @Override
    public PrimitiveLongIterator fuzzyQuery(Collection<String> terms, boolean matchAll) {
        String query = terms.stream().map(QueryParserBase::escape).collect(Collectors.joining("~ ", "", "~"));
        return this.innerQuery(query, matchAll);
    }

    @Override
    public void close() {
        try {
            this.partitionSearcher.close();
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    @Override
    public FulltextIndexConfiguration getConfigurationDocument() throws IOException {
        IndexSearcher indexSearcher = this.getIndexSearcher();
        TopDocs docs = indexSearcher.search((Query)new TermQuery(FulltextIndexConfiguration.TERM), 1);
        if (docs.scoreDocs.length < 1) {
            return null;
        }
        return new FulltextIndexConfiguration(indexSearcher.doc(docs.scoreDocs[0].doc));
    }

    private PrimitiveLongIterator innerQuery(String queryString, boolean matchAll) {
        Query query;
        MultiFieldQueryParser multiFieldQueryParser = new MultiFieldQueryParser(this.properties, this.analyzer);
        if (matchAll) {
            multiFieldQueryParser.setDefaultOperator(QueryParser.Operator.AND);
        } else {
            multiFieldQueryParser.setDefaultOperator(QueryParser.Operator.OR);
        }
        try {
            query = multiFieldQueryParser.parse(queryString);
        }
        catch (ParseException e) {
            assert (false);
            return PrimitiveLongCollections.emptyIterator();
        }
        return this.indexQuery(query);
    }

    private PrimitiveLongIterator indexQuery(Query query) {
        try {
            DocValuesCollector docValuesCollector = new DocValuesCollector(true);
            this.getIndexSearcher().search(query, (Collector)docValuesCollector);
            return docValuesCollector.getSortedValuesIterator("__lucene__fulltext__addon__internal__id__", Sort.RELEVANCE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private IndexSearcher getIndexSearcher() {
        return this.partitionSearcher.getIndexSearcher();
    }
}

