/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexConfiguration;
import org.neo4j.kernel.api.impl.fulltext.ReadOnlyFulltext;
import org.neo4j.kernel.api.impl.fulltext.SimpleFulltextReader;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.schema.reader.IndexReaderCloseException;

class PartitionedFulltextReader
implements ReadOnlyFulltext {
    private final List<ReadOnlyFulltext> indexReaders;

    PartitionedFulltextReader(List<PartitionSearcher> partitionSearchers, String[] properties, Analyzer analyzer) {
        this(partitionSearchers.stream().map(partitionSearcher -> new SimpleFulltextReader((PartitionSearcher)partitionSearcher, properties, analyzer)).collect(Collectors.toList()));
    }

    private PartitionedFulltextReader(List<ReadOnlyFulltext> readers) {
        this.indexReaders = readers;
    }

    @Override
    public PrimitiveLongIterator query(Collection<String> terms, boolean matchAll) {
        return this.partitionedOperation(reader -> this.innerQuery((ReadOnlyFulltext)reader, matchAll, terms));
    }

    @Override
    public PrimitiveLongIterator fuzzyQuery(Collection<String> terms, boolean matchAll) {
        return this.partitionedOperation(reader -> this.innerFuzzyQuery((ReadOnlyFulltext)reader, matchAll, terms));
    }

    private PrimitiveLongIterator innerQuery(ReadOnlyFulltext reader, boolean matchAll, Collection<String> query) {
        return reader.query(query, matchAll);
    }

    private PrimitiveLongIterator innerFuzzyQuery(ReadOnlyFulltext reader, boolean matchAll, Collection<String> query) {
        return reader.fuzzyQuery(query, matchAll);
    }

    @Override
    public void close() {
        try {
            IOUtils.closeAll(this.indexReaders);
        }
        catch (IOException e) {
            throw new IndexReaderCloseException(e);
        }
    }

    @Override
    public FulltextIndexConfiguration getConfigurationDocument() throws IOException {
        for (ReadOnlyFulltext indexReader : this.indexReaders) {
            FulltextIndexConfiguration config = indexReader.getConfigurationDocument();
            if (config == null) continue;
            return config;
        }
        return null;
    }

    private PrimitiveLongIterator partitionedOperation(Function<ReadOnlyFulltext, PrimitiveLongIterator> readerFunction) {
        return PrimitiveLongCollections.concat((Iterable)this.indexReaders.parallelStream().map(readerFunction).collect(Collectors.toList()));
    }
}

