/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextFieldEncoding;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class LuceneFulltextDocumentStructure {
    private static final ThreadLocal<DocWithId> perThreadDocument = ThreadLocal.withInitial(() -> new DocWithId());

    private LuceneFulltextDocumentStructure() {
    }

    private static DocWithId reuseDocument(long id) {
        DocWithId doc = perThreadDocument.get();
        doc.setId(id);
        return doc;
    }

    static Document documentRepresentingProperties(long id, Map<String, Object> values) {
        DocWithId document = LuceneFulltextDocumentStructure.reuseDocument(id);
        document.setValues(values);
        return document.document;
    }

    static Field encodeValueField(String propertyKey, Value value) {
        return LuceneFulltextFieldEncoding.encodeField(propertyKey, value);
    }

    static Term newTermForChangeOrRemove(long id) {
        return new Term("__lucene__fulltext__addon__internal__id__", "" + id);
    }

    private static class DocWithId {
        private final Document document;
        private final Field idField = new StringField("__lucene__fulltext__addon__internal__id__", "", Field.Store.NO);
        private final Field idValueField = new NumericDocValuesField("__lucene__fulltext__addon__internal__id__", 0L);

        private DocWithId() {
            this.document = new Document();
            this.document.add((IndexableField)this.idField);
            this.document.add((IndexableField)this.idValueField);
        }

        private void setId(long id) {
            this.removeAllValueFields();
            this.idField.setStringValue(Long.toString(id));
            this.idValueField.setLongValue(id);
        }

        private void setValues(Map<String, Object> values) {
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                Field field = LuceneFulltextDocumentStructure.encodeValueField(entry.getKey(), Values.of((Object)entry.getValue()));
                this.document.add((IndexableField)field);
            }
        }

        private void removeAllValueFields() {
            Iterator it = this.document.getFields().iterator();
            while (it.hasNext()) {
                IndexableField field = (IndexableField)it.next();
                String fieldName = field.name();
                if (fieldName.equals("__lucene__fulltext__addon__internal__id__")) continue;
                it.remove();
            }
        }
    }
}

