/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexConfiguration;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexType;
import org.neo4j.kernel.api.impl.fulltext.PartitionedFulltextReader;
import org.neo4j.kernel.api.impl.fulltext.ReadOnlyFulltext;
import org.neo4j.kernel.api.impl.fulltext.SimpleFulltextReader;
import org.neo4j.kernel.api.impl.fulltext.WritableFulltext;
import org.neo4j.kernel.api.impl.index.AbstractLuceneIndex;
import org.neo4j.kernel.api.impl.index.WritableAbstractDatabaseIndex;
import org.neo4j.kernel.api.impl.index.partition.AbstractIndexPartition;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.PartitionSearcher;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;
import org.neo4j.kernel.api.impl.schema.writer.PartitionedIndexWriter;
import org.neo4j.kernel.api.index.InternalIndexState;

class LuceneFulltext
extends AbstractLuceneIndex {
    private final Analyzer analyzer;
    private final String identifier;
    private final FulltextIndexType type;
    private Set<String> properties;
    private volatile InternalIndexState state;

    LuceneFulltext(PartitionedIndexStorage indexStorage, IndexPartitionFactory partitionFactory, Collection<String> properties, Analyzer analyzer, String identifier, FulltextIndexType type) {
        super(indexStorage, partitionFactory);
        this.properties = Collections.unmodifiableSet(new HashSet<String>(properties));
        this.analyzer = analyzer;
        this.identifier = identifier;
        this.type = type;
        this.state = InternalIndexState.POPULATING;
    }

    LuceneFulltext(PartitionedIndexStorage indexStorage, WritableIndexPartitionFactory partitionFactory, Analyzer analyzer, String identifier, FulltextIndexType type) throws IOException {
        this(indexStorage, (IndexPartitionFactory)partitionFactory, Collections.EMPTY_SET, analyzer, identifier, type);
        this.properties = this.readProperties();
    }

    private Set<String> readProperties() throws IOException {
        FulltextIndexConfiguration configurationDocument;
        this.open();
        try (ReadOnlyFulltext indexReader = this.getIndexReader();){
            configurationDocument = indexReader.getConfigurationDocument();
        }
        Set<String> props = configurationDocument != null ? Collections.unmodifiableSet(configurationDocument.getProperties()) : Collections.emptySet();
        this.close();
        return props;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LuceneFulltext that = (LuceneFulltext)((Object)o);
        if (!this.identifier.equals(that.identifier)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.identifier, this.type});
    }

    PartitionedIndexWriter getIndexWriter(WritableFulltext writableIndex) throws IOException {
        this.ensureOpen();
        return new PartitionedIndexWriter((WritableAbstractDatabaseIndex)writableIndex);
    }

    ReadOnlyFulltext getIndexReader() throws IOException {
        this.ensureOpen();
        List partitions = this.getPartitions();
        return this.hasSinglePartition(partitions) ? this.createSimpleReader(partitions) : this.createPartitionedReader(partitions);
    }

    FulltextIndexType getType() {
        return this.type;
    }

    Set<String> getProperties() {
        return this.properties;
    }

    String getIdentifier() {
        return this.identifier;
    }

    private SimpleFulltextReader createSimpleReader(List<AbstractIndexPartition> partitions) throws IOException {
        AbstractIndexPartition singlePartition = this.getFirstPartition(partitions);
        PartitionSearcher partitionSearcher = singlePartition.acquireSearcher();
        return new SimpleFulltextReader(partitionSearcher, this.properties.toArray(new String[0]), this.analyzer);
    }

    private PartitionedFulltextReader createPartitionedReader(List<AbstractIndexPartition> partitions) throws IOException {
        List searchers = LuceneFulltext.acquireSearchers(partitions);
        return new PartitionedFulltextReader(searchers, this.properties.toArray(new String[0]), this.analyzer);
    }

    void saveConfiguration(long txId) throws IOException {
        PartitionedIndexWriter writer = this.getIndexWriter(new WritableFulltext(this));
        String analyzerName = this.analyzer.getClass().getCanonicalName();
        FulltextIndexConfiguration config = new FulltextIndexConfiguration(analyzerName, this.properties, txId);
        writer.updateDocument(FulltextIndexConfiguration.TERM, config.asDocument());
    }

    String getAnalyzerName() {
        return this.analyzer.getClass().getCanonicalName();
    }

    InternalIndexState getState() {
        return this.state;
    }

    void setPopulated() {
        this.state = InternalIndexState.ONLINE;
    }

    void setFailed() {
        this.state = InternalIndexState.FAILED;
    }
}

