/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.kernel.api.impl.fulltext.AsyncFulltextIndexOperation;
import org.neo4j.kernel.api.impl.fulltext.FulltextProviderImpl;
import org.neo4j.kernel.api.impl.fulltext.FulltextUpdateApplier;
import org.neo4j.kernel.api.impl.fulltext.WritableFulltext;

class FulltextTransactionEventUpdater
implements TransactionEventHandler<FulltextTransactionContext> {
    private final FulltextProviderImpl fulltextProvider;
    private final FulltextUpdateApplier applier;

    FulltextTransactionEventUpdater(FulltextProviderImpl fulltextProvider, FulltextUpdateApplier applier) {
        this.fulltextProvider = fulltextProvider;
        this.applier = applier;
    }

    public FulltextTransactionContext beforeCommit(TransactionData data) throws Exception {
        HashMap nodeMap = new HashMap();
        HashMap relationshipMap = new HashMap();
        Lock lock = this.fulltextProvider.readLockIndexConfiguration();
        FulltextTransactionContext fulltextTransactionContext = new FulltextTransactionContext(nodeMap, relationshipMap, lock);
        String[] nodeProperties = this.fulltextProvider.getNodeProperties();
        data.removedNodeProperties().forEach(propertyEntry -> {
            try {
                nodeMap.put(((Node)propertyEntry.entity()).getId(), ((Node)propertyEntry.entity()).getProperties(nodeProperties));
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        });
        data.assignedNodeProperties().forEach(propertyEntry -> nodeMap.put(((Node)propertyEntry.entity()).getId(), ((Node)propertyEntry.entity()).getProperties(nodeProperties)));
        String[] relationshipProperties = this.fulltextProvider.getRelationshipProperties();
        data.removedRelationshipProperties().forEach(propertyEntry -> {
            try {
                relationshipMap.put(((Relationship)propertyEntry.entity()).getId(), ((Relationship)propertyEntry.entity()).getProperties(relationshipProperties));
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        });
        data.assignedRelationshipProperties().forEach(propertyEntry -> relationshipMap.put(((Relationship)propertyEntry.entity()).getId(), ((Relationship)propertyEntry.entity()).getProperties(relationshipProperties)));
        return fulltextTransactionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCommit(TransactionData data, FulltextTransactionContext state) {
        RuntimeException applyException = null;
        ArrayList<AsyncFulltextIndexOperation> completions = new ArrayList<AsyncFulltextIndexOperation>();
        try {
            try {
                Map<Long, Map<String, Object>> nodeMap = state.getNodeMap();
                Map<Long, Map<String, Object>> relationshipMap = state.getRelationshipMap();
                for (WritableFulltext nodeIndex : this.fulltextProvider.writableNodeIndices()) {
                    completions.add(this.applier.removePropertyData(data.removedNodeProperties(), nodeMap, nodeIndex));
                    completions.add(this.applier.updatePropertyData(nodeMap, nodeIndex));
                }
                for (WritableFulltext relationshipIndex : this.fulltextProvider.writableRelationshipIndices()) {
                    completions.add(this.applier.removePropertyData(data.removedRelationshipProperties(), relationshipMap, relationshipIndex));
                    completions.add(this.applier.updatePropertyData(relationshipMap, relationshipIndex));
                }
            }
            catch (IOException e) {
                applyException = new RuntimeException("Failed to submit all index updates.", e);
            }
            for (AsyncFulltextIndexOperation completion : completions) {
                try {
                    completion.awaitCompletion();
                }
                catch (ExecutionException e) {
                    if (applyException == null) {
                        applyException = new RuntimeException("Failed to update fulltext index. See suppressed exceptions for details.");
                    }
                    applyException.addSuppressed(e);
                }
            }
            if (applyException != null) {
                throw applyException;
            }
        }
        finally {
            state.release();
        }
    }

    public void afterRollback(TransactionData data, FulltextTransactionContext state) {
        state.release();
    }

    public static class FulltextTransactionContext {
        private final Map<Long, Map<String, Object>> nodeMap;
        private final Map<Long, Map<String, Object>> relationshipMap;
        private final Lock lock;

        private FulltextTransactionContext(Map<Long, Map<String, Object>> nodeMap, Map<Long, Map<String, Object>> relationshipMap, Lock lock) {
            this.nodeMap = nodeMap;
            this.relationshipMap = relationshipMap;
            this.lock = lock;
        }

        public Map<Long, Map<String, Object>> getRelationshipMap() {
            return this.relationshipMap;
        }

        public Map<Long, Map<String, Object>> getNodeMap() {
            return this.nodeMap;
        }

        public void release() {
            this.lock.unlock();
        }
    }
}

