/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.impl.fulltext.FulltextFactory;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexConfiguration;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexType;
import org.neo4j.kernel.api.impl.fulltext.FulltextProvider;
import org.neo4j.kernel.api.impl.fulltext.FulltextTransactionEventUpdater;
import org.neo4j.kernel.api.impl.fulltext.FulltextUpdateApplier;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltext;
import org.neo4j.kernel.api.impl.fulltext.ReadOnlyFulltext;
import org.neo4j.kernel.api.impl.fulltext.WritableFulltext;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;

public class FulltextProviderImpl
implements FulltextProvider {
    private final GraphDatabaseService db;
    private final Log log;
    private final TransactionIdStore transactionIdStore;
    private final FulltextTransactionEventUpdater fulltextTransactionEventUpdater;
    private final Set<String> nodeProperties;
    private final Set<String> relationshipProperties;
    private final Map<String, WritableFulltext> writableNodeIndices;
    private final Map<String, WritableFulltext> writableRelationshipIndices;
    private final FulltextUpdateApplier applier;
    private final FulltextFactory factory;
    private final ReadWriteLock configurationLock;

    public FulltextProviderImpl(GraphDatabaseService db, Log log, AvailabilityGuard availabilityGuard, JobScheduler scheduler, TransactionIdStore transactionIdStore, FileSystemAbstraction fileSystem, File storeDir, String analyzerClassName) throws IOException {
        this.db = db;
        this.log = log;
        this.transactionIdStore = transactionIdStore;
        this.applier = new FulltextUpdateApplier(log, availabilityGuard, scheduler);
        this.applier.start();
        this.factory = new FulltextFactory(fileSystem, storeDir, analyzerClassName);
        this.fulltextTransactionEventUpdater = new FulltextTransactionEventUpdater(this, this.applier);
        this.nodeProperties = ConcurrentHashMap.newKeySet();
        this.relationshipProperties = ConcurrentHashMap.newKeySet();
        this.writableNodeIndices = new ConcurrentHashMap<String, WritableFulltext>();
        this.writableRelationshipIndices = new ConcurrentHashMap<String, WritableFulltext>();
        this.configurationLock = new ReentrantReadWriteLock(true);
    }

    @Override
    public void registerTransactionEventHandler() throws IOException {
        this.db.registerTransactionEventHandler((TransactionEventHandler)this.fulltextTransactionEventUpdater);
    }

    private boolean matchesConfiguration(WritableFulltext index) throws IOException {
        FulltextIndexConfiguration storedConfig;
        long txId = this.transactionIdStore.getLastCommittedTransactionId();
        FulltextIndexConfiguration currentConfig = new FulltextIndexConfiguration(index.getAnalyzerName(), index.getProperties(), txId);
        try (ReadOnlyFulltext indexReader = index.getIndexReader();){
            storedConfig = indexReader.getConfigurationDocument();
        }
        return storedConfig == null && index.getProperties().isEmpty() || storedConfig != null && storedConfig.equals(currentConfig);
    }

    @Override
    public void awaitPopulation() {
        try {
            this.applier.writeBarrier().awaitCompletion();
        }
        catch (ExecutionException e) {
            throw new AssertionError("The writeBarrier operation should never throw an exception", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void openIndex(String identifier, FulltextIndexType type) throws IOException {
        LuceneFulltext index = this.factory.openFulltextIndex(identifier, type);
        this.register(index);
    }

    @Override
    public void createIndex(String identifier, FulltextIndexType type, List<String> properties) throws IOException {
        LuceneFulltext index = this.factory.createFulltextIndex(identifier, type, properties);
        this.register(index);
    }

    private void register(LuceneFulltext fulltextIndex) throws IOException {
        this.configurationLock.writeLock().lock();
        try {
            WritableFulltext writableFulltext = new WritableFulltext(fulltextIndex);
            writableFulltext.open();
            if (fulltextIndex.getType() == FulltextIndexType.NODES) {
                if (!this.matchesConfiguration(writableFulltext)) {
                    writableFulltext.drop();
                    writableFulltext.open();
                    if (!writableFulltext.getProperties().isEmpty()) {
                        this.applier.populateNodes(writableFulltext, this.db);
                    }
                }
                this.writableNodeIndices.put(fulltextIndex.getIdentifier(), writableFulltext);
                this.nodeProperties.addAll(fulltextIndex.getProperties());
            } else {
                if (!this.matchesConfiguration(writableFulltext)) {
                    writableFulltext.drop();
                    writableFulltext.open();
                    if (!writableFulltext.getProperties().isEmpty()) {
                        this.applier.populateRelationships(writableFulltext, this.db);
                    }
                }
                this.writableRelationshipIndices.put(fulltextIndex.getIdentifier(), writableFulltext);
                this.relationshipProperties.addAll(fulltextIndex.getProperties());
            }
        }
        finally {
            this.configurationLock.writeLock().unlock();
        }
    }

    String[] getNodeProperties() {
        return this.nodeProperties.toArray(new String[0]);
    }

    String[] getRelationshipProperties() {
        return this.relationshipProperties.toArray(new String[0]);
    }

    Collection<WritableFulltext> writableNodeIndices() {
        return Collections.unmodifiableCollection(this.writableNodeIndices.values());
    }

    Collection<WritableFulltext> writableRelationshipIndices() {
        return Collections.unmodifiableCollection(this.writableRelationshipIndices.values());
    }

    @Override
    public ReadOnlyFulltext getReader(String identifier, FulltextIndexType type) throws IOException {
        WritableFulltext writableFulltext = this.getIndexMap(type).get(identifier);
        if (writableFulltext == null) {
            throw new IllegalArgumentException("No such " + (Object)((Object)type) + " index '" + identifier + "'.");
        }
        return writableFulltext.getIndexReader();
    }

    private Map<String, WritableFulltext> getIndexMap(FulltextIndexType type) {
        switch (type) {
            case NODES: {
                return this.writableNodeIndices;
            }
            case RELATIONSHIPS: {
                return this.writableRelationshipIndices;
            }
        }
        throw new IllegalArgumentException("No such fulltext index type: " + (Object)((Object)type));
    }

    @Override
    public Set<String> getProperties(String identifier, FulltextIndexType type) {
        return this.applyToMatchingIndex(identifier, type, WritableFulltext::getProperties);
    }

    private <E> E applyToMatchingIndex(String identifier, FulltextIndexType type, Function<WritableFulltext, E> function) {
        if (type == FulltextIndexType.NODES) {
            return function.apply(this.writableNodeIndices.get(identifier));
        }
        return function.apply(this.writableRelationshipIndices.get(identifier));
    }

    @Override
    public InternalIndexState getState(String identifier, FulltextIndexType type) {
        return this.applyToMatchingIndex(identifier, type, WritableFulltext::getState);
    }

    void drop(String identifier, FulltextIndexType type) throws IOException {
        this.configurationLock.writeLock().lock();
        try {
            this.awaitPopulation();
            if (type == FulltextIndexType.NODES) {
                this.writableNodeIndices.remove(identifier).drop();
            } else {
                this.writableRelationshipIndices.remove(identifier).drop();
            }
            this.rebuildProperties();
        }
        finally {
            this.configurationLock.writeLock().unlock();
        }
    }

    private void rebuildProperties() {
        this.nodeProperties.clear();
        this.relationshipProperties.clear();
        this.writableNodeIndices.forEach((s, index) -> this.nodeProperties.addAll(index.getProperties()));
        this.writableRelationshipIndices.forEach((s, index) -> this.relationshipProperties.addAll(index.getProperties()));
    }

    Lock readLockIndexConfiguration() {
        Lock lock = this.configurationLock.readLock();
        lock.lock();
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeIndexedProperties(String identifier, FulltextIndexType type, List<String> propertyKeys) throws IOException, InvalidArgumentsException {
        this.configurationLock.writeLock().lock();
        try {
            if (propertyKeys.stream().anyMatch(s -> s.startsWith("__lucene__fulltext__addon__"))) {
                throw new InvalidArgumentsException("It is not possible to index property keys starting with __lucene__fulltext__addon__");
            }
            Set<String> currentProperties = this.getProperties(identifier, type);
            if (!currentProperties.containsAll(propertyKeys) || !propertyKeys.containsAll(currentProperties)) {
                this.drop(identifier, type);
                this.createIndex(identifier, type, propertyKeys);
            }
        }
        finally {
            this.configurationLock.writeLock().unlock();
        }
    }

    @Override
    public void close() {
        this.db.unregisterTransactionEventHandler((TransactionEventHandler)this.fulltextTransactionEventUpdater);
        this.applier.stop();
        Consumer<WritableFulltext> fulltextCloser = luceneFulltextIndex -> {
            try {
                luceneFulltextIndex.saveConfiguration(this.transactionIdStore.getLastCommittedTransactionId());
                luceneFulltextIndex.close();
            }
            catch (IOException e) {
                this.log.error("Unable to close fulltext index.", (Throwable)e);
            }
        };
        this.writableNodeIndices.values().forEach(fulltextCloser);
        this.writableRelationshipIndices.values().forEach(fulltextCloser);
    }
}

