/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexType;
import org.neo4j.kernel.api.impl.fulltext.ReadOnlyFulltext;
import org.neo4j.kernel.api.index.InternalIndexState;

public interface FulltextProvider
extends AutoCloseable {
    public static final FulltextProvider NULL_PROVIDER = new FulltextProvider(){

        @Override
        public void registerTransactionEventHandler() throws IOException {
            throw this.noProvider();
        }

        @Override
        public void awaitPopulation() {
            throw this.noProvider();
        }

        @Override
        public void openIndex(String identifier, FulltextIndexType type) throws IOException {
            throw this.noProvider();
        }

        @Override
        public void createIndex(String identifier, FulltextIndexType type, List<String> properties) throws IOException {
            throw this.noProvider();
        }

        @Override
        public ReadOnlyFulltext getReader(String identifier, FulltextIndexType type) throws IOException {
            throw this.noProvider();
        }

        @Override
        public Set<String> getProperties(String identifier, FulltextIndexType type) {
            throw this.noProvider();
        }

        @Override
        public InternalIndexState getState(String identifier, FulltextIndexType type) {
            throw this.noProvider();
        }

        @Override
        public void changeIndexedProperties(String identifier, FulltextIndexType type, List<String> propertyKeys) throws IOException, InvalidArgumentsException {
            throw this.noProvider();
        }

        @Override
        public void close() throws Exception {
            throw this.noProvider();
        }

        private RuntimeException noProvider() {
            return new UnsupportedOperationException("There is no fulltext provider for this database. Make sure that the feature you are tyring to use is enabled");
        }
    };
    public static final String LUCENE_FULLTEXT_ADDON_PREFIX = "__lucene__fulltext__addon__";
    public static final String FIELD_ENTITY_ID = "__lucene__fulltext__addon__internal__id__";

    public void registerTransactionEventHandler() throws IOException;

    public void awaitPopulation();

    public void openIndex(String var1, FulltextIndexType var2) throws IOException;

    public void createIndex(String var1, FulltextIndexType var2, List<String> var3) throws IOException;

    public ReadOnlyFulltext getReader(String var1, FulltextIndexType var2) throws IOException;

    public Set<String> getProperties(String var1, FulltextIndexType var2);

    public InternalIndexState getState(String var1, FulltextIndexType var2);

    public void changeIndexedProperties(String var1, FulltextIndexType var2, List<String> var3) throws IOException, InvalidArgumentsException;
}

