/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;

class FulltextIndexConfiguration {
    private static final String FIELD_METADATA_DOC = "__lucene__fulltext__addon__metadata__doc__field__";
    private static final String FIELD_CONFIG_ANALYZER = "__lucene__fulltext__addon__analyzer";
    private static final String FIELD_CONFIG_PROPERTIES = "__lucene__fulltext__addon__properties";
    private static final String FIELD_LAST_COMMITTED_TX_ID = "__lucene__fulltext__addon__tx__id";
    static Term TERM = new Term("__lucene__fulltext__addon__metadata__doc__field__");
    private final Set<String> properties;
    private final String analyzerClassName;
    private final long txId;

    FulltextIndexConfiguration(Document doc) {
        this.properties = new HashSet<String>(Arrays.asList(doc.getValues(FIELD_CONFIG_PROPERTIES)));
        this.analyzerClassName = doc.get(FIELD_CONFIG_ANALYZER);
        this.txId = Long.parseLong(doc.get(FIELD_LAST_COMMITTED_TX_ID));
    }

    FulltextIndexConfiguration(String analyzerClassName, Set<String> properties, long txId) {
        this.properties = properties;
        this.analyzerClassName = analyzerClassName;
        this.txId = txId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulltextIndexConfiguration that = (FulltextIndexConfiguration)o;
        return this.txId == that.txId && this.properties.equals(that.properties) && this.analyzerClassName.equals(that.analyzerClassName);
    }

    public int hashCode() {
        int result = this.properties.hashCode();
        result = 31 * result + this.analyzerClassName.hashCode();
        result = 31 * result + (int)(this.txId ^ this.txId >>> 32);
        return result;
    }

    Document asDocument() {
        Document doc = new Document();
        doc.add((IndexableField)new StringField(FIELD_METADATA_DOC, "", Field.Store.NO));
        doc.add((IndexableField)new StoredField(FIELD_CONFIG_ANALYZER, this.analyzerClassName));
        doc.add((IndexableField)new LongField(FIELD_LAST_COMMITTED_TX_ID, this.txId, Field.Store.YES));
        for (String property : this.properties) {
            doc.add((IndexableField)new StoredField(FIELD_CONFIG_PROPERTIES, property));
        }
        return doc;
    }

    public Set<String> getProperties() {
        return this.properties;
    }
}

