/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.neo4j.function.Factory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexType;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltext;
import org.neo4j.kernel.api.impl.index.IndexWriterConfigs;
import org.neo4j.kernel.api.impl.index.builder.LuceneIndexStorageBuilder;
import org.neo4j.kernel.api.impl.index.partition.IndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.partition.WritableIndexPartitionFactory;
import org.neo4j.kernel.api.impl.index.storage.PartitionedIndexStorage;

class FulltextFactory {
    public static final String INDEX_DIR = "bloom_fts";
    private final FileSystemAbstraction fileSystem;
    private final WritableIndexPartitionFactory partitionFactory;
    private final File indexDir;
    private final Analyzer analyzer;

    FulltextFactory(FileSystemAbstraction fileSystem, File storeDir, String analyzerClassName) throws IOException {
        this.analyzer = this.getAnalyzer(analyzerClassName);
        this.fileSystem = fileSystem;
        Factory indexWriterConfigFactory = () -> IndexWriterConfigs.standard((Analyzer)this.analyzer);
        this.partitionFactory = new WritableIndexPartitionFactory(indexWriterConfigFactory);
        this.indexDir = new File(storeDir, INDEX_DIR);
    }

    private Analyzer getAnalyzer(String analyzerClassName) {
        Analyzer analyzer;
        try {
            Class<?> configuredAnalyzer = Class.forName(analyzerClassName);
            analyzer = (Analyzer)configuredAnalyzer.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create the configured analyzer", e);
        }
        return analyzer;
    }

    LuceneFulltext createFulltextIndex(String identifier, FulltextIndexType type, List<String> properties) throws IOException {
        File indexRootFolder = new File(this.indexDir, identifier);
        LuceneIndexStorageBuilder storageBuilder = LuceneIndexStorageBuilder.create();
        storageBuilder.withFileSystem(this.fileSystem).withIndexFolder(indexRootFolder);
        PartitionedIndexStorage storage = storageBuilder.build();
        return new LuceneFulltext(storage, (IndexPartitionFactory)this.partitionFactory, properties, this.analyzer, identifier, type);
    }

    LuceneFulltext openFulltextIndex(String identifier, FulltextIndexType type) throws IOException {
        File indexRootFolder = new File(this.indexDir, identifier);
        LuceneIndexStorageBuilder storageBuilder = LuceneIndexStorageBuilder.create();
        storageBuilder.withFileSystem(this.fileSystem).withIndexFolder(indexRootFolder);
        PartitionedIndexStorage storage = storageBuilder.build();
        return new LuceneFulltext(storage, this.partitionFactory, this.analyzer, identifier, type);
    }
}

