/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext.integrations.bloom;

import java.util.Date;
import java.util.Iterator;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.checking.full.ConsistencyFlags;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.impl.fulltext.integrations.bloom.BloomFulltextConfig;
import org.neo4j.kernel.api.impl.fulltext.integrations.bloom.BloomProcedures;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class BloomIT {
    private static final String NODES = "CALL bloom.searchNodes([%s])";
    private static final String NODES_ADVANCED = "CALL bloom.searchNodes([%s], %b, %b)";
    private static final String RELS = "CALL bloom.searchRelationships([%s])";
    private static final String RELS_ADVANCED = "CALL bloom.searchRelationships([%s], %b, %b)";
    private static final String ENTITYID = "entityid";
    private static final String SET_NODE_KEYS = "CALL bloom.setIndexedNodePropertyKeys([%s])";
    private static final String SET_REL_KEYS = "CALL bloom.setIndexedRelationshipPropertyKeys([%s])";
    private static final String GET_NODE_KEYS = "CALL bloom.getIndexedNodePropertyKeys";
    private static final String GET_REL_KEYS = "CALL bloom.getIndexedNodePropertyKeys";
    private static final String AWAIT_POPULATION = "CALL bloom.awaitPopulation";
    private static final String STATUS = "CALL bloom.indexStatus";
    @Rule
    public final DefaultFileSystemRule fs = new DefaultFileSystemRule();
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private GraphDatabaseService db;
    private GraphDatabaseBuilder builder;

    @Before
    public void before() throws Exception {
        GraphDatabaseFactory factory = new GraphDatabaseFactory();
        this.builder = factory.newEmbeddedDatabaseBuilder(this.testDirectory.graphDbDir()).setConfig(BloomFulltextConfig.bloom_enabled, "true");
    }

    @After
    public void after() throws Exception {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    private GraphDatabaseService getDb() throws KernelException {
        GraphDatabaseService db = this.builder.newGraphDatabase();
        ((Procedures)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(Procedures.class)).registerProcedure(BloomProcedures.class);
        return db;
    }

    @Test
    public void shouldPopulateAndQueryIndexes() throws Exception {
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\", \"relprop\""));
        this.db.execute(String.format(SET_REL_KEYS, "\"prop\", \"relprop\""));
        try (Transaction transaction = this.db.beginTx();){
            Node node1 = this.db.createNode();
            node1.setProperty("prop", (Object)"This is a integration test.");
            Node node2 = this.db.createNode();
            node2.setProperty("prop", (Object)"This is a related integration test");
            Relationship relationship = node1.createRelationshipTo(node2, RelationshipType.withName((String)"type"));
            relationship.setProperty("relprop", (Object)"They relate");
            transaction.success();
        }
        Result result = this.db.execute(String.format(NODES, "\"integration\""));
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)0L, result.next().get(ENTITYID));
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)1L, result.next().get(ENTITYID));
        Assert.assertFalse((boolean)result.hasNext());
        result = this.db.execute(String.format(RELS, "\"relate\""));
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)0L, result.next().get(ENTITYID));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void exactQueryShouldBeExact() throws Exception {
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        this.db.execute(String.format(SET_REL_KEYS, "\"prop\""));
        try (Transaction transaction = this.db.beginTx();){
            Node node1 = this.db.createNode();
            node1.setProperty("prop", (Object)"This is a integration test.");
            Node node2 = this.db.createNode();
            node2.setProperty("prop", (Object)"This is a related integration test");
            Relationship relationship = node1.createRelationshipTo(node2, RelationshipType.withName((String)"type"));
            relationship.setProperty("prop", (Object)"They relate");
            transaction.success();
        }
        Result result = this.db.execute(String.format(NODES_ADVANCED, "\"integration\"", false, false));
        Assert.assertEquals((Object)0L, result.next().get(ENTITYID));
        Assert.assertEquals((Object)1L, result.next().get(ENTITYID));
        Assert.assertFalse((boolean)result.hasNext());
        result = this.db.execute(String.format(NODES_ADVANCED, "\"integratiun\"", false, false));
        Assert.assertFalse((boolean)result.hasNext());
        result = this.db.execute(String.format(RELS_ADVANCED, "\"relate\"", false, false));
        Assert.assertEquals((Object)0L, result.next().get(ENTITYID));
        Assert.assertFalse((boolean)result.hasNext());
        result = this.db.execute(String.format(RELS_ADVANCED, "\"relite\"", false, false));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void matchAllQueryShouldMatchAll() throws Exception {
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        this.db.execute(String.format(SET_REL_KEYS, "\"prop\""));
        try (Transaction transaction = this.db.beginTx();){
            Node node1 = this.db.createNode();
            node1.setProperty("prop", (Object)"This is a integration test.");
            Node node2 = this.db.createNode();
            node2.setProperty("prop", (Object)"This is a related integration test");
            Relationship relationship = node1.createRelationshipTo(node2, RelationshipType.withName((String)"type"));
            relationship.setProperty("prop", (Object)"They relate");
            transaction.success();
        }
        Result result = this.db.execute(String.format(NODES_ADVANCED, "\"integration\", \"related\"", false, true));
        Assert.assertEquals((Object)1L, result.next().get(ENTITYID));
        Assert.assertFalse((boolean)result.hasNext());
        result = this.db.execute(String.format(RELS_ADVANCED, "\"they\", \"relate\"", false, true));
        Assert.assertEquals((Object)0L, result.next().get(ENTITYID));
        Assert.assertFalse((boolean)result.hasNext());
        result = this.db.execute(String.format(RELS_ADVANCED, "\"relate\", \"sometimes\"", false, true));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldBeAbleToConfigureAnalyzer() throws Exception {
        this.builder.setConfig(BloomFulltextConfig.bloom_default_analyzer, "org.apache.lucene.analysis.sv.SwedishAnalyzer");
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        try (Transaction transaction = this.db.beginTx();){
            Node node1 = this.db.createNode();
            node1.setProperty("prop", (Object)"Det finns en mening");
            Node node2 = this.db.createNode();
            node2.setProperty("prop", (Object)"There is a sentance");
            transaction.success();
        }
        Result result = this.db.execute(String.format(NODES, "\"is\""));
        Assert.assertEquals((Object)1L, result.next().get(ENTITYID));
        Assert.assertFalse((boolean)result.hasNext());
        result = this.db.execute(String.format(NODES, "\"a\""));
        Assert.assertEquals((Object)1L, result.next().get(ENTITYID));
        Assert.assertFalse((boolean)result.hasNext());
        result = this.db.execute(String.format(NODES, "\"det\""));
        Assert.assertFalse((boolean)result.hasNext());
        result = this.db.execute(String.format(NODES, "\"en\""));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldPopulateIndexWithExistingDataOnIndexCreate() throws Exception {
        long nodeId;
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"something\""));
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            node.setProperty("prop", (Object)"Roskildevej 32");
            nodeId = node.getId();
            tx.success();
        }
        Result result = this.db.execute(String.format(NODES, "\"Roskildevej\""));
        Assert.assertFalse((boolean)result.hasNext());
        this.db.shutdown();
        this.builder.setConfig(BloomFulltextConfig.bloom_default_analyzer, "org.apache.lucene.analysis.da.DanishAnalyzer");
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        this.db.execute(AWAIT_POPULATION).close();
        result = this.db.execute(String.format(NODES, "\"Roskildevej\""));
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)nodeId, result.next().get(ENTITYID));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void startupPopulationShouldNotCauseDuplicates() throws Exception {
        long nodeId;
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            nodeId = node.getId();
            node.setProperty("prop", (Object)"Jyllingevej");
            tx.success();
        }
        this.db.execute(AWAIT_POPULATION).close();
        Result result = this.db.execute(String.format(NODES, "\"Jyllingevej\""));
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)nodeId, result.next().get(ENTITYID));
        Assert.assertFalse((boolean)result.hasNext());
        this.db.shutdown();
        this.db = this.getDb();
        this.db.execute(AWAIT_POPULATION).close();
        result = this.db.execute(String.format(NODES, "\"Jyllingevej\""));
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)nodeId, result.next().get(ENTITYID));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void shouldNotBeAbleToFindNodesAfterRemovingIndex() throws Exception {
        long nodeId;
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            nodeId = node.getId();
            node.setProperty("prop", (Object)"Jyllingevej");
            tx.success();
        }
        this.db.execute(AWAIT_POPULATION).close();
        Result result = this.db.execute(String.format(NODES, "\"Jyllingevej\""));
        Assert.assertTrue((boolean)result.hasNext());
        Assert.assertEquals((Object)nodeId, result.next().get(ENTITYID));
        Assert.assertFalse((boolean)result.hasNext());
        this.db.execute(String.format(SET_NODE_KEYS, ""));
        this.db.execute(AWAIT_POPULATION).close();
        result = this.db.execute(String.format(NODES, "\"Jyllingevej\""));
        Assert.assertFalse((boolean)result.hasNext());
        this.db.shutdown();
        this.db = this.getDb();
        result = this.db.execute(String.format(NODES, "\"Jyllingevej\""));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void staleDataFromEntityDeleteShouldNotBeAccessibleAfterConfigurationChange() throws Exception {
        long nodeId;
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            nodeId = node.getId();
            node.setProperty("prop", (Object)"Esplanaden");
            tx.success();
        }
        this.db.shutdown();
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"not-prop\""));
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            this.db.getNodeById(nodeId).delete();
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.db.shutdown();
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        this.db.execute(AWAIT_POPULATION).close();
        Result result = this.db.execute(String.format(NODES, "\"Esplanaden\""));
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Test
    public void staleDataFromPropertyRemovalShouldNotBeAccessibleAfterConfigurationChange() throws Exception {
        long nodeId;
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            nodeId = node.getId();
            node.setProperty("prop", (Object)"Esplanaden");
            tx.success();
        }
        this.db.shutdown();
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"not-prop\""));
        tx = this.db.beginTx();
        var4_2 = null;
        try {
            this.db.getNodeById(nodeId).removeProperty("prop");
            tx.success();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.db.shutdown();
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        this.db.execute(AWAIT_POPULATION).close();
        Result result = this.db.execute(String.format(NODES, "\"Esplanaden\""));
        Assert.assertFalse((boolean)result.hasNext());
        result.close();
    }

    @Test
    public void updatesAreAvailableToConcurrentReadTransactions() throws Exception {
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode().setProperty("prop", (Object)"Langelinie Pavillinen");
            tx.success();
        }
        var2_2 = null;
        try (Transaction ignore = this.db.beginTx();){
            try (Result result = this.db.execute(String.format(NODES, "\"Langelinie\""));){
                Assert.assertThat((Object)Iterators.count((Iterator)result), (Matcher)Matchers.is((Object)1L));
            }
            Thread th = new Thread(() -> {
                try (Transaction tx1 = this.db.beginTx();){
                    this.db.createNode().setProperty("prop", (Object)"Den Lille Havfrue, Langelinie");
                    tx1.success();
                }
            });
            th.start();
            th.join();
            try (Result result = this.db.execute(String.format(NODES, "\"Langelinie\""));){
                Assert.assertThat((Object)Iterators.count((Iterator)result), (Matcher)Matchers.is((Object)2L));
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldNotBeAbleToStartWithIllegalPropertyKey() throws Exception {
        this.expectedException.expectMessage("It is not possible to index property keys starting with __lucene__fulltext__addon__");
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\", \"__lucene__fulltext__addon__internal__id__\", \"hello\""));
    }

    @Test
    public void shouldBeAbleToRunConsistencyCheck() throws Exception {
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode().setProperty("prop", (Object)"Langelinie Pavillinen");
            tx.success();
        }
        this.db.shutdown();
        Config config = Config.defaults((Setting)BloomFulltextConfig.bloom_enabled, (String)"true");
        ConsistencyCheckService consistencyCheckService = new ConsistencyCheckService(new Date());
        ConsistencyFlags checkConsistencyConfig = new ConsistencyFlags(true, true, true, true);
        ConsistencyCheckService.Result result = consistencyCheckService.runFullConsistencyCheck(this.testDirectory.graphDbDir(), config, ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), true, checkConsistencyConfig);
        Assert.assertTrue((boolean)result.isSuccessful());
    }

    @Test
    public void shouldReindexNodesWhenAnalyzerIsChanged() throws Exception {
        Throwable throwable;
        Result result;
        String ENGLISH = EnglishAnalyzer.class.getCanonicalName();
        String SWEDISH = SwedishAnalyzer.class.getCanonicalName();
        this.builder.setConfig(BloomFulltextConfig.bloom_default_analyzer, ENGLISH);
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode().setProperty("prop", (Object)"Hello and hello again.");
            this.db.createNode().setProperty("prop", (Object)"En tomte bodde i ett hus.");
            tx.success();
        }
        var4_4 = null;
        try (Transaction ignore = this.db.beginTx();){
            result = this.db.execute(String.format(NODES_ADVANCED, "\"and\"", false, false));
            throwable = null;
            try {
                Assert.assertThat((Object)Iterators.count((Iterator)result), (Matcher)Matchers.is((Object)0L));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        result.close();
                    }
                }
            }
            result = this.db.execute(String.format(NODES_ADVANCED, "\"ett\"", false, false));
            throwable = null;
            try {
                Assert.assertThat((Object)Iterators.count((Iterator)result), (Matcher)Matchers.is((Object)1L));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        catch (Throwable result2) {
            var4_4 = result2;
            throw result2;
        }
        this.db.shutdown();
        this.builder.setConfig(BloomFulltextConfig.bloom_default_analyzer, SWEDISH);
        this.db = this.getDb();
        this.db.execute(AWAIT_POPULATION).close();
        ignore = this.db.beginTx();
        var4_4 = null;
        try {
            result = this.db.execute(String.format(NODES_ADVANCED, "\"and\"", false, false));
            throwable = null;
            try {
                Assert.assertThat((Object)Iterators.count((Iterator)result), (Matcher)Matchers.is((Object)1L));
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        result.close();
                    }
                }
            }
            result = this.db.execute(String.format(NODES_ADVANCED, "\"ett\"", false, false));
            throwable = null;
            try {
                Assert.assertThat((Object)Iterators.count((Iterator)result), (Matcher)Matchers.is((Object)0L));
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (result != null) {
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        catch (Throwable throwable10) {
            var4_4 = throwable10;
            throw throwable10;
        }
        finally {
            if (ignore != null) {
                if (var4_4 != null) {
                    try {
                        ignore.close();
                    }
                    catch (Throwable throwable11) {
                        var4_4.addSuppressed(throwable11);
                    }
                } else {
                    ignore.close();
                }
            }
        }
    }

    @Test
    public void shouldReindexAfterBeingTemporarilyDisabled() throws Exception {
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode().setProperty("prop", (Object)"Hello and hello again.");
            tx.success();
        }
        this.db.shutdown();
        this.builder.setConfig(BloomFulltextConfig.bloom_enabled, "false");
        this.db = this.builder.newGraphDatabase();
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.createNode().setProperty("prop", (Object)"En tomte bodde i ett hus.");
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        this.db.shutdown();
        this.builder.setConfig(BloomFulltextConfig.bloom_enabled, "true");
        this.db = this.getDb();
        this.db.execute(AWAIT_POPULATION).close();
        var2_2 = null;
        try (Transaction ignore = this.db.beginTx();){
            try (Result result = this.db.execute(String.format(NODES_ADVANCED, "\"hello\"", false, false));){
                Assert.assertThat((Object)Iterators.count((Iterator)result), (Matcher)Matchers.is((Object)1L));
            }
            result = this.db.execute(String.format(NODES_ADVANCED, "\"tomte\"", false, false));
            var4_11 = null;
            try {
                Assert.assertThat((Object)Iterators.count((Iterator)result), (Matcher)Matchers.is((Object)1L));
            }
            catch (Throwable throwable) {
                var4_11 = throwable;
                throw throwable;
            }
            finally {
                if (result != null) {
                    if (var4_11 != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable) {
                            var4_11.addSuppressed(throwable);
                        }
                    } else {
                        result.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void indexedPropertiesShouldBeSetByProcedure() throws Exception {
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\""));
        try (Transaction tx = this.db.beginTx();){
            this.db.createNode().setProperty("prop", (Object)"Hello and hello again.");
            tx.success();
        }
        var2_2 = null;
        try (Transaction ignore = this.db.beginTx();
             Result result = this.db.execute(String.format(NODES_ADVANCED, "\"hello\"", false, false));){
            Assert.assertThat((Object)Iterators.count((Iterator)result), (Matcher)Matchers.is((Object)1L));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldBeAbleToQueryForIndexedProperties() throws Exception {
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop\", \"otherprop\", \"proppmatt\""));
        Result result = this.db.execute("CALL bloom.getIndexedNodePropertyKeys");
        Assert.assertEquals((Object)"otherprop", result.next().get("propertyKey"));
        Assert.assertEquals((Object)"prop", result.next().get("propertyKey"));
        Assert.assertEquals((Object)"proppmatt", result.next().get("propertyKey"));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void onlineIndexShouldBeReportedAsOnline() throws Exception {
        this.db = this.getDb();
        this.db.execute(String.format(SET_NODE_KEYS, "\"prop, otherprop, proppmatt\""));
        this.db.execute(String.format(SET_REL_KEYS, "\"prop, otherprop, proppmatt\""));
        this.db.execute(AWAIT_POPULATION);
        Result result = this.db.execute(STATUS);
        Assert.assertEquals((Object)"ONLINE", result.next().get("state"));
        Assert.assertEquals((Object)"ONLINE", result.next().get("state"));
        Assert.assertFalse((boolean)result.hasNext());
    }

    @Test
    public void databaseShouldBeAbleToStartWithBloomPresentButDisabled() throws Exception {
        this.builder.setConfig(BloomFulltextConfig.bloom_enabled, "false");
        this.db = this.getDb();
    }

    @Test
    public void shouldThrowSomewhatHelpfulMessageIfCalledWhenDisabled() throws Exception {
        this.builder.setConfig(BloomFulltextConfig.bloom_enabled, "false");
        this.db = this.getDb();
        this.expectedException.expect(QueryExecutionException.class);
        this.expectedException.expectMessage("enabled");
        this.db.execute(AWAIT_POPULATION);
    }
}

