/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Arrays;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexType;
import org.neo4j.kernel.api.impl.fulltext.FulltextProvider;
import org.neo4j.kernel.api.impl.fulltext.FulltextProviderImpl;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.kernel.api.impl.fulltext.ReadOnlyFulltext;
import org.neo4j.test.Race;

public class LuceneFulltextUpdaterTest
extends LuceneFulltextTestSupport {
    @Test
    public void shouldFindNodeWithString() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long secondID;
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue("Hello. Hello again.");
                secondID = this.createNodeIndexableByPropertyValue("A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
                tx.success();
            }
            var8_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIds(reader, "hello", false, firstID);
                this.assertExactQueryFindsIds(reader, "zebra", false, secondID);
                this.assertExactQueryFindsIds(reader, "zedonk", false, secondID);
                this.assertExactQueryFindsIds(reader, "cross", false, secondID);
            }
            catch (Throwable throwable) {
                var8_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldFindNodeWithNumber() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long secondID;
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue(1);
                secondID = this.createNodeIndexableByPropertyValue(234);
                tx.success();
            }
            var8_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIds(reader, "1", false, firstID);
                this.assertExactQueryFindsIds(reader, "234", false, secondID);
            }
            catch (Throwable throwable) {
                var8_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldFindNodeWithBoolean() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long secondID;
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue(true);
                secondID = this.createNodeIndexableByPropertyValue(false);
                tx.success();
            }
            var8_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIds(reader, "true", false, firstID);
                this.assertExactQueryFindsIds(reader, "false", false, secondID);
            }
            catch (Throwable throwable) {
                var8_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldFindNodeWithArrays() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long thirdID;
            long secondID;
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue(new String[]{"hello", "I", "live", "here"});
                secondID = this.createNodeIndexableByPropertyValue(new int[]{1, 27, 48});
                thirdID = this.createNodeIndexableByPropertyValue(new int[]{1, 2, 48});
                tx.success();
            }
            var10_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIds(reader, "live", false, firstID);
                this.assertExactQueryFindsIds(reader, "27", false, secondID);
                this.assertExactQueryFindsIds(reader, Arrays.asList("1", "2"), false, secondID, thirdID);
            }
            catch (Throwable throwable) {
                var10_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldRepresentPropertyChanges() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long secondID;
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue("Hello. Hello again.");
                secondID = this.createNodeIndexableByPropertyValue("A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
                tx.success();
            }
            tx = this.db.beginTx();
            var8_4 = null;
            try {
                this.setNodeProp(firstID, "Hahahaha! potato!");
                this.setNodeProp(secondID, "This one is a potato farmer.");
                tx.success();
            }
            catch (Throwable throwable) {
                var8_4 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var8_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var8_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            var8_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsNothing(reader, "hello");
                this.assertExactQueryFindsNothing(reader, "zebra");
                this.assertExactQueryFindsNothing(reader, "zedonk");
                this.assertExactQueryFindsNothing(reader, "cross");
                this.assertExactQueryFindsIds(reader, "hahahaha", false, firstID);
                this.assertExactQueryFindsIds(reader, "farmer", false, secondID);
                this.assertExactQueryFindsIds(reader, "potato", false, firstID, secondID);
            }
            catch (Throwable throwable) {
                var8_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldNotFindRemovedNodes() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long secondID;
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue("Hello. Hello again.");
                secondID = this.createNodeIndexableByPropertyValue("A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
                tx.success();
            }
            tx = this.db.beginTx();
            var8_4 = null;
            try {
                this.db.getNodeById(firstID).delete();
                this.db.getNodeById(secondID).delete();
                tx.success();
            }
            catch (Throwable throwable) {
                var8_4 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var8_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var8_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            var8_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsNothing(reader, "hello");
                this.assertExactQueryFindsNothing(reader, "zebra");
                this.assertExactQueryFindsNothing(reader, "zedonk");
                this.assertExactQueryFindsNothing(reader, "cross");
            }
            catch (Throwable throwable) {
                var8_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldNotFindRemovedProperties() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long thirdID;
            long secondID;
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Arrays.asList("prop", "prop2"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue("Hello. Hello again.");
                secondID = this.createNodeIndexableByPropertyValue("A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
                thirdID = this.createNodeIndexableByPropertyValue("Hello. Hello again.");
                this.setNodeProp(firstID, "zebra");
                this.setNodeProp(secondID, "Hello. Hello again.");
                tx.success();
            }
            tx = this.db.beginTx();
            var10_4 = null;
            try {
                Node node = this.db.getNodeById(firstID);
                Node node2 = this.db.getNodeById(secondID);
                Node node3 = this.db.getNodeById(thirdID);
                node.setProperty("prop", (Object)"tomtar");
                node.setProperty("prop2", (Object)"tomtar");
                node2.setProperty("prop", (Object)"tomtar");
                node2.setProperty("prop2", (Object)"Hello");
                node3.removeProperty("prop");
                tx.success();
            }
            catch (Throwable throwable) {
                var10_4 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var10_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var10_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            var10_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIds(reader, "hello", false, secondID);
                this.assertExactQueryFindsNothing(reader, "zebra");
                this.assertExactQueryFindsNothing(reader, "zedonk");
                this.assertExactQueryFindsNothing(reader, "cross");
            }
            catch (Throwable throwable) {
                var10_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldOnlyIndexIndexedProperties() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue("Hello. Hello again.");
                this.setNodeProp(firstID, "prop2", "zebra");
                Node node2 = this.db.createNode();
                node2.setProperty("prop2", (Object)"zebra");
                node2.setProperty("prop3", (Object)"hello");
                tx.success();
            }
            var6_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIds(reader, "hello", false, firstID);
                this.assertExactQueryFindsNothing(reader, "zebra");
            }
            catch (Throwable throwable) {
                var6_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldSearchAcrossMultipleProperties() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long thirdID;
            long secondID;
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Arrays.asList("prop", "prop2"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue("Tomtar tomtar oftsat i tomteutstyrsel.");
                secondID = this.createNodeIndexableByPropertyValue("Olof och Hans");
                this.setNodeProp(secondID, "prop2", "och karl");
                Node node3 = this.db.createNode();
                thirdID = node3.getId();
                node3.setProperty("prop2", (Object)"Tomtar som inte tomtar ser upp till tomtar som tomtar.");
                tx.success();
            }
            var10_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIds(reader, Arrays.asList("tomtar", "karl"), false, firstID, secondID, thirdID);
            }
            catch (Throwable throwable) {
                var10_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldOrderResultsBasedOnRelevance() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long fourthID;
            long thirdID;
            long secondID;
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Arrays.asList("first", "last"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.db.createNode().getId();
                secondID = this.db.createNode().getId();
                thirdID = this.db.createNode().getId();
                fourthID = this.db.createNode().getId();
                this.setNodeProp(firstID, "first", "Full");
                this.setNodeProp(firstID, "last", "Hanks");
                this.setNodeProp(secondID, "first", "Tom");
                this.setNodeProp(secondID, "last", "Hunk");
                this.setNodeProp(thirdID, "first", "Tom");
                this.setNodeProp(thirdID, "last", "Hanks");
                this.setNodeProp(fourthID, "first", "Tom Hanks");
                this.setNodeProp(fourthID, "last", "Tom Hanks");
                tx.success();
            }
            var12_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIdsInOrder(reader, Arrays.asList("Tom", "Hanks"), false, fourthID, thirdID, firstID, secondID);
            }
            catch (Throwable throwable) {
                var12_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldDifferentiateNodesAndRelationships() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long secondRelID;
            long firstRelID;
            long secondNodeID;
            long firstNodeID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.createIndex("relationships", FulltextIndexType.RELATIONSHIPS, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstNodeID = this.createNodeIndexableByPropertyValue("Hello. Hello again.");
                secondNodeID = this.createNodeIndexableByPropertyValue("A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
                firstRelID = this.createRelationshipIndexableByPropertyValue(firstNodeID, secondNodeID, "Hello. Hello again.");
                secondRelID = this.createRelationshipIndexableByPropertyValue(secondNodeID, firstNodeID, "And now, something completely different");
                tx.success();
            }
            var12_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIds(reader, "hello", false, firstNodeID);
                this.assertExactQueryFindsIds(reader, "zebra", false, secondNodeID);
                this.assertExactQueryFindsNothing(reader, "different");
            }
            catch (Throwable throwable) {
                var12_4 = throwable;
                throw throwable;
            }
            reader = provider.getReader("relationships", FulltextIndexType.RELATIONSHIPS);
            var12_4 = null;
            try {
                this.assertExactQueryFindsIds(reader, "hello", false, firstRelID);
                this.assertExactQueryFindsNothing(reader, "zebra");
                this.assertExactQueryFindsIds(reader, "different", false, secondRelID);
            }
            catch (Throwable throwable) {
                var12_4 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var12_4 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var12_4.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
    }

    @Test
    public void fuzzyQueryShouldBeFuzzy() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long secondID;
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue("Hello. Hello again.");
                secondID = this.createNodeIndexableByPropertyValue("A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
                tx.success();
            }
            var8_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertFuzzyQueryFindsIds(reader, "hella", false, firstID);
                this.assertFuzzyQueryFindsIds(reader, "zebre", false, secondID);
                this.assertFuzzyQueryFindsIds(reader, "zedink", false, secondID);
                this.assertFuzzyQueryFindsIds(reader, "cruss", false, secondID);
                this.assertExactQueryFindsNothing(reader, "hella");
                this.assertExactQueryFindsNothing(reader, "zebre");
                this.assertExactQueryFindsNothing(reader, "zedink");
                this.assertExactQueryFindsNothing(reader, "cruss");
            }
            catch (Throwable throwable) {
                var8_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void fuzzyQueryShouldReturnExactMatchesFirst() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long fourthID;
            long thirdID;
            long secondID;
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue("zibre");
                secondID = this.createNodeIndexableByPropertyValue("zebrae");
                thirdID = this.createNodeIndexableByPropertyValue("zebra");
                fourthID = this.createNodeIndexableByPropertyValue("zibra");
                tx.success();
            }
            var12_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertFuzzyQueryFindsIdsInOrder(reader, "zebra", true, thirdID, secondID, fourthID, firstID);
            }
            catch (Throwable throwable) {
                var12_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldNotReturnNonMatches() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.createIndex("relationships", FulltextIndexType.RELATIONSHIPS, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                long firstNode = this.createNodeIndexableByPropertyValue("Hello. Hello again.");
                long secondNode = this.createNodeWithProperty("prop2", "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
                this.createRelationshipIndexableByPropertyValue(firstNode, secondNode, "Hello. Hello again.");
                this.createRelationshipWithProperty(secondNode, firstNode, "prop2", "A zebroid (also zedonk, zorse, zebra mule, zonkey, and zebmule) is the offspring of any cross between a zebra and any other equine: essentially, a zebra hybrid.");
                tx.success();
            }
            var4_6 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsNothing(reader, "zebra");
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            reader = provider.getReader("relationships", FulltextIndexType.RELATIONSHIPS);
            var4_6 = null;
            try {
                this.assertExactQueryFindsNothing(reader, "zebra");
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var4_6 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
    }

    @Test
    public void shouldPopulateIndexWithExistingNodesAndRelationships() throws Exception {
        long secondRelID;
        long firstRelID;
        long secondNodeID;
        long firstNodeID;
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode();
            node.createRelationshipTo(node, RELTYPE);
            node.createRelationshipTo(node, RELTYPE);
            node.createRelationshipTo(node, RELTYPE);
            firstNodeID = this.createNodeIndexableByPropertyValue("Hello. Hello again.");
            secondNodeID = this.createNodeIndexableByPropertyValue("This string is slightly shorter than the zebra one");
            firstRelID = this.createRelationshipIndexableByPropertyValue(firstNodeID, secondNodeID, "Goodbye");
            secondRelID = this.createRelationshipIndexableByPropertyValue(secondNodeID, firstNodeID, "And now, something completely different");
            tx.success();
        }
        var10_2 = null;
        try (FulltextProviderImpl provider = this.createProvider();){
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.createIndex("relationships", FulltextIndexType.RELATIONSHIPS, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            provider.awaitPopulation();
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIds(reader, "hello", false, firstNodeID);
                this.assertExactQueryFindsIds(reader, "string", false, secondNodeID);
                this.assertExactQueryFindsNothing(reader, "goodbye");
                this.assertExactQueryFindsNothing(reader, "different");
            }
            reader = provider.getReader("relationships", FulltextIndexType.RELATIONSHIPS);
            var12_13 = null;
            try {
                this.assertExactQueryFindsNothing(reader, "hello");
                this.assertExactQueryFindsNothing(reader, "string");
                this.assertExactQueryFindsIds(reader, "goodbye", false, firstRelID);
                this.assertExactQueryFindsIds(reader, "different", false, secondRelID);
            }
            catch (Throwable throwable) {
                var12_13 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var12_13 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var12_13.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            var10_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldReturnMatchesThatContainLuceneSyntaxCharacters() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long nodeId;
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            String[] luceneSyntaxElements = new String[]{"+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "\"", "~", "*", "?", ":", "\\"};
            try (Transaction tx = this.db.beginTx();){
                nodeId = this.db.createNodeId();
                tx.success();
            }
            for (String elm : luceneSyntaxElements) {
                this.setNodeProp(nodeId, "Hello" + elm + " How are you " + elm + "today?");
                try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                    this.assertExactQueryFindsIds(reader, "Hello" + elm, false, nodeId);
                    this.assertExactQueryFindsIds(reader, elm + "today", false, nodeId);
                }
            }
        }
    }

    @Test
    public void exactMatchAllShouldOnlyReturnStuffThatMatchesAll() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long fifthID;
            long fourthID;
            long thirdID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Arrays.asList("first", "last"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                long firstID = this.db.createNode().getId();
                long secondID = this.db.createNode().getId();
                thirdID = this.db.createNode().getId();
                fourthID = this.db.createNode().getId();
                fifthID = this.db.createNode().getId();
                this.setNodeProp(firstID, "first", "Full");
                this.setNodeProp(firstID, "last", "Hanks");
                this.setNodeProp(secondID, "first", "Tom");
                this.setNodeProp(secondID, "last", "Hunk");
                this.setNodeProp(thirdID, "first", "Tom");
                this.setNodeProp(thirdID, "last", "Hanks");
                this.setNodeProp(fourthID, "first", "Tom Hanks");
                this.setNodeProp(fourthID, "last", "Tom Hanks");
                this.setNodeProp(fifthID, "last", "Tom Hanks");
                this.setNodeProp(fifthID, "first", "Morgan");
                tx.success();
            }
            var14_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIds(reader, Arrays.asList("Tom", "Hanks"), true, thirdID, fourthID, fifthID);
            }
            catch (Throwable throwable) {
                var14_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void fuzzyMatchAllShouldOnlyReturnStuffThatKindaMatchesAll() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long fifthID;
            long fourthID;
            long thirdID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Arrays.asList("first", "last"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                long firstID = this.db.createNode().getId();
                long secondID = this.db.createNode().getId();
                thirdID = this.db.createNode().getId();
                fourthID = this.db.createNode().getId();
                fifthID = this.db.createNode().getId();
                this.setNodeProp(firstID, "first", "Christian");
                this.setNodeProp(firstID, "last", "Hanks");
                this.setNodeProp(secondID, "first", "Tom");
                this.setNodeProp(secondID, "last", "Hungarian");
                this.setNodeProp(thirdID, "first", "Tom");
                this.setNodeProp(thirdID, "last", "Hunk");
                this.setNodeProp(fourthID, "first", "Tim");
                this.setNodeProp(fourthID, "last", "Hanks");
                this.setNodeProp(fifthID, "last", "Tom Hanks");
                this.setNodeProp(fifthID, "first", "Morgan");
                tx.success();
            }
            var14_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertFuzzyQueryFindsIds(reader, Arrays.asList("Tom", "Hanks"), true, thirdID, fourthID, fifthID);
            }
            catch (Throwable throwable) {
                var14_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldBeAbleToUpdateAndQueryAfterIndexChange() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long fourthID;
            long thirdID;
            long secondID;
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue("thing");
                secondID = this.db.createNode().getId();
                this.setNodeProp(secondID, "prop2", "zebra");
                thirdID = this.createNodeIndexableByPropertyValue("zebra");
                tx.success();
            }
            var12_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIds(reader, Arrays.asList("thing", "zebra"), false, firstID, thirdID);
            }
            catch (Throwable throwable) {
                var12_4 = throwable;
                throw throwable;
            }
            provider.changeIndexedProperties("nodes", FulltextIndexType.NODES, Collections.singletonList("prop2"));
            tx = this.db.beginTx();
            var12_4 = null;
            try {
                this.setNodeProp(firstID, "prop2", "thing");
                fourthID = this.db.createNode().getId();
                this.setNodeProp(fourthID, "prop2", "zebra");
                tx.success();
            }
            catch (Throwable throwable) {
                var12_4 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var12_4 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var12_4.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
            reader = provider.getReader("nodes", FulltextIndexType.NODES);
            var12_4 = null;
            try {
                this.assertExactQueryFindsIds(reader, Arrays.asList("thing", "zebra"), false, firstID, secondID, fourthID);
            }
            catch (Throwable throwable) {
                var12_4 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var12_4 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var12_4.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
    }

    @Test
    public void shouldBeAbleToDropAndReaddIndex() throws Exception {
        try (FulltextProviderImpl provider = this.createProvider();){
            long secondID;
            long firstID;
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue("thing");
                secondID = this.createNodeIndexableByPropertyValue("zebra");
                tx.success();
            }
            provider.drop("nodes", FulltextIndexType.NODES);
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.awaitPopulation();
            var8_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIds(reader, Arrays.asList("thing", "zebra"), false, firstID, secondID);
            }
            catch (Throwable throwable) {
                var8_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void concurrentUpdatesAndIndexChangesShouldResultInValidState() throws Throwable {
        try (FulltextProviderImpl provider = this.createProvider();){
            provider.createIndex("nodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            int aliceThreads = 10;
            int bobthreads = 10;
            int nodesCreatedPerThread = 10;
            Race race = new Race();
            Runnable aliceWork = () -> {
                for (int i = 0; i < nodesCreatedPerThread; ++i) {
                    try (Transaction tx = this.db.beginTx();){
                        this.createNodeIndexableByPropertyValue("alice");
                        tx.success();
                        continue;
                    }
                }
            };
            Runnable changeConfig = () -> LuceneFulltextUpdaterTest.lambda$concurrentUpdatesAndIndexChangesShouldResultInValidState$1((FulltextProvider)provider);
            Runnable bobWork = () -> {
                for (int i = 0; i < nodesCreatedPerThread; ++i) {
                    try (Transaction tx = this.db.beginTx();){
                        this.createNodeWithProperty("otherProp", "bob");
                        tx.success();
                        continue;
                    }
                }
            };
            race.addContestants(aliceThreads, aliceWork);
            race.addContestant(changeConfig);
            race.addContestants(bobthreads, bobWork);
            race.go();
            try (ReadOnlyFulltext reader = provider.getReader("nodes", FulltextIndexType.NODES);){
                PrimitiveLongIterator bob = reader.query(Collections.singletonList("bob"), true);
                Assert.assertEquals((long)(bobthreads * nodesCreatedPerThread), (long)PrimitiveLongCollections.count((PrimitiveLongIterator)bob));
                PrimitiveLongIterator alice = reader.query(Collections.singletonList("alice"), true);
                Assert.assertEquals((long)0L, (long)PrimitiveLongCollections.count((PrimitiveLongIterator)alice));
            }
        }
    }

    private static /* synthetic */ void lambda$concurrentUpdatesAndIndexChangesShouldResultInValidState$1(FulltextProvider provider) {
        try {
            provider.changeIndexedProperties("nodes", FulltextIndexType.NODES, Collections.singletonList("otherProp"));
            provider.awaitPopulation();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

