/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.api.impl.fulltext.FulltextProviderImpl;
import org.neo4j.kernel.api.impl.fulltext.ReadOnlyFulltext;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class LuceneFulltextTestSupport {
    protected static final String ANALYZER = StandardAnalyzer.class.getCanonicalName();
    protected static final Log LOG = NullLog.getInstance();
    @Rule
    public DatabaseRule dbRule = new EmbeddedDatabaseRule().startLazily();
    protected static final RelationshipType RELTYPE = RelationshipType.withName((String)"type");
    protected String analyzer = ANALYZER;
    protected AvailabilityGuard availabilityGuard = new AvailabilityGuard(Clock.systemDefaultZone(), LOG);
    protected GraphDatabaseAPI db;
    protected JobScheduler scheduler;
    protected FileSystemAbstraction fs;
    protected File storeDir;
    private TransactionIdStore transactionIdStore;

    @Before
    public void setUp() throws Throwable {
        this.db = this.dbRule.getGraphDatabaseAPI();
        this.scheduler = (JobScheduler)this.dbRule.resolveDependency(JobScheduler.class);
        this.fs = (FileSystemAbstraction)this.dbRule.resolveDependency(FileSystemAbstraction.class);
        this.storeDir = this.dbRule.getStoreDir();
        this.transactionIdStore = (TransactionIdStore)this.dbRule.resolveDependency(TransactionIdStore.class);
    }

    protected FulltextProviderImpl createProvider() throws IOException {
        return new FulltextProviderImpl((GraphDatabaseService)this.db, LOG, this.availabilityGuard, this.scheduler, this.transactionIdStore, this.fs, this.storeDir, this.analyzer);
    }

    protected long createNodeIndexableByPropertyValue(Object propertyValue) {
        return this.createNodeWithProperty("prop", propertyValue);
    }

    protected long createNodeWithProperty(String propertyKey, Object propertyValue) {
        Node node = this.db.createNode();
        node.setProperty(propertyKey, propertyValue);
        return node.getId();
    }

    protected long createRelationshipIndexableByPropertyValue(long firstNodeId, long secondNodeId, Object propertyValue) {
        return this.createRelationshipWithProperty(firstNodeId, secondNodeId, "prop", propertyValue);
    }

    protected long createRelationshipWithProperty(long firstNodeId, long secondNodeId, String propertyKey, Object propertyValue) {
        Node first = this.db.getNodeById(firstNodeId);
        Node second = this.db.getNodeById(secondNodeId);
        Relationship relationship = first.createRelationshipTo(second, RELTYPE);
        relationship.setProperty(propertyKey, propertyValue);
        return relationship.getId();
    }

    protected void assertExactQueryFindsNothing(ReadOnlyFulltext reader, String query) {
        this.assertExactQueryFindsIds(reader, query, false, new long[0]);
    }

    protected void assertExactQueryFindsIds(ReadOnlyFulltext reader, Collection<String> query, boolean matchAll, long ... ids) {
        PrimitiveLongIterator result = reader.query(query, matchAll);
        this.assertQueryResultsMatch(result, ids);
    }

    protected void assertExactQueryFindsIdsInOrder(ReadOnlyFulltext reader, Collection<String> query, boolean matchAll, long ... ids) {
        PrimitiveLongIterator result = reader.query(query, matchAll);
        this.assertQueryResultsMatchInOrder(result, ids);
    }

    protected void assertExactQueryFindsIds(ReadOnlyFulltext reader, String query, boolean matchAll, long ... ids) {
        this.assertExactQueryFindsIds(reader, Arrays.asList(query), matchAll, ids);
    }

    protected void assertFuzzyQueryFindsIds(ReadOnlyFulltext reader, String query, boolean matchAll, long ... ids) {
        this.assertFuzzyQueryFindsIds(reader, Arrays.asList(query), matchAll, ids);
    }

    protected void assertFuzzyQueryFindsIds(ReadOnlyFulltext reader, Collection<String> query, boolean matchAll, long ... ids) {
        PrimitiveLongIterator result = reader.fuzzyQuery(query, matchAll);
        this.assertQueryResultsMatch(result, ids);
    }

    protected void assertFuzzyQueryFindsIdsInOrder(ReadOnlyFulltext reader, String query, boolean matchAll, long ... ids) {
        PrimitiveLongIterator result = reader.fuzzyQuery(Arrays.asList(query), matchAll);
        this.assertQueryResultsMatchInOrder(result, ids);
    }

    protected void assertQueryResultsMatch(PrimitiveLongIterator result, long[] ids) {
        PrimitiveLongSet set = PrimitiveLongCollections.setOf((long[])ids);
        while (result.hasNext()) {
            long next = result.next();
            Assert.assertTrue((String)String.format("Result returned node id %d, expected one of %s", next, Arrays.toString(ids)), (boolean)set.remove(next));
        }
        Assert.assertTrue((String)"Number of results differ from expected", (boolean)set.isEmpty());
    }

    protected void assertQueryResultsMatchInOrder(PrimitiveLongIterator result, long[] ids) {
        int num = 0;
        while (result.hasNext()) {
            long next = result.next();
            Assert.assertEquals((String)String.format("Result returned node id %d, expected %d", next, ids[num]), (long)ids[num], (long)next);
            ++num;
        }
        Assert.assertEquals((String)"Number of results differ from expected", (long)ids.length, (long)num);
    }

    protected void setNodeProp(long nodeId, String value) {
        this.setNodeProp(nodeId, "prop", value);
    }

    protected void setNodeProp(long nodeId, String propertyKey, String value) {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.getNodeById(nodeId);
            node.setProperty(propertyKey, (Object)value);
            tx.success();
        }
    }
}

