/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.util.Collections;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.impl.fulltext.FulltextIndexType;
import org.neo4j.kernel.api.impl.fulltext.FulltextProviderImpl;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextTestSupport;
import org.neo4j.kernel.api.impl.fulltext.ReadOnlyFulltext;

public class FulltextAnalyzerTest
extends LuceneFulltextTestSupport {
    private static final String ENGLISH = EnglishAnalyzer.class.getCanonicalName();
    private static final String SWEDISH = SwedishAnalyzer.class.getCanonicalName();

    @Test
    public void shouldBeAbleToSpecifyEnglishAnalyzer() throws Exception {
        this.analyzer = ENGLISH;
        try (FulltextProviderImpl provider = this.createProvider();){
            long id;
            provider.createIndex("bloomNodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                this.createNodeIndexableByPropertyValue("Hello and hello again, in the end.");
                id = this.createNodeIndexableByPropertyValue("En apa och en tomte bodde i ett hus.");
                tx.success();
            }
            var6_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("bloomNodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsNothing(reader, "and");
                this.assertExactQueryFindsNothing(reader, "in");
                this.assertExactQueryFindsNothing(reader, "the");
                this.assertExactQueryFindsIds(reader, "en", false, id);
                this.assertExactQueryFindsIds(reader, "och", false, id);
                this.assertExactQueryFindsIds(reader, "ett", false, id);
            }
            catch (Throwable throwable) {
                var6_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldBeAbleToSpecifySwedishAnalyzer() throws Exception {
        this.analyzer = SWEDISH;
        try (FulltextProviderImpl provider = this.createProvider();){
            long id;
            provider.createIndex("bloomNodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            try (Transaction tx = this.db.beginTx();){
                id = this.createNodeIndexableByPropertyValue("Hello and hello again, in the end.");
                this.createNodeIndexableByPropertyValue("En apa och en tomte bodde i ett hus.");
                tx.success();
            }
            var6_4 = null;
            try (ReadOnlyFulltext reader = provider.getReader("bloomNodes", FulltextIndexType.NODES);){
                this.assertExactQueryFindsIds(reader, "and", false, id);
                this.assertExactQueryFindsIds(reader, "in", false, id);
                this.assertExactQueryFindsIds(reader, "the", false, id);
                this.assertExactQueryFindsNothing(reader, "en");
                this.assertExactQueryFindsNothing(reader, "och");
                this.assertExactQueryFindsNothing(reader, "ett");
            }
            catch (Throwable throwable) {
                var6_4 = throwable;
                throw throwable;
            }
        }
    }

    @Test
    public void shouldReindexNodesWhenAnalyzerIsChanged() throws Exception {
        ReadOnlyFulltext reader;
        long firstID;
        Throwable throwable;
        this.analyzer = ENGLISH;
        try (FulltextProviderImpl provider = this.createProvider();){
            long secondID;
            provider.createIndex("bloomNodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            throwable = null;
            try (Transaction tx = this.db.beginTx();){
                firstID = this.createNodeIndexableByPropertyValue("Hello and hello again, in the end.");
                secondID = this.createNodeIndexableByPropertyValue("En apa och en tomte bodde i ett hus.");
                tx.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            reader = provider.getReader("bloomNodes", FulltextIndexType.NODES);
            throwable = null;
            try {
                this.assertExactQueryFindsNothing(reader, "and");
                this.assertExactQueryFindsNothing(reader, "in");
                this.assertExactQueryFindsNothing(reader, "the");
                this.assertExactQueryFindsIds(reader, "en", false, secondID);
                this.assertExactQueryFindsIds(reader, "och", false, secondID);
                this.assertExactQueryFindsIds(reader, "ett", false, secondID);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        this.analyzer = SWEDISH;
        provider = this.createProvider();
        var6_2 = null;
        try {
            provider.createIndex("bloomNodes", FulltextIndexType.NODES, Collections.singletonList("prop"));
            provider.registerTransactionEventHandler();
            provider.awaitPopulation();
            reader = provider.getReader("bloomNodes", FulltextIndexType.NODES);
            throwable = null;
            try {
                this.assertExactQueryFindsIds(reader, "and", false, firstID);
                this.assertExactQueryFindsIds(reader, "in", false, firstID);
                this.assertExactQueryFindsIds(reader, "the", false, firstID);
                this.assertExactQueryFindsNothing(reader, "en");
                this.assertExactQueryFindsNothing(reader, "och");
                this.assertExactQueryFindsNothing(reader, "ett");
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (Throwable throwable7) {
            var6_2 = throwable7;
            throw throwable7;
        }
        finally {
            if (provider != null) {
                if (var6_2 != null) {
                    try {
                        provider.close();
                    }
                    catch (Throwable throwable8) {
                        var6_2.addSuppressed(throwable8);
                    }
                } else {
                    provider.close();
                }
            }
        }
    }
}

