/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.upgrade;

import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.pagecache.ConfigurableStandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.highlimit.HighLimit;
import org.neo4j.kernel.impl.store.format.highlimit.v300.HighLimitV3_0_0;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class RecordFormatsMigrationIT {
    private static final Label LABEL = Label.label((String)"Centipede");
    private static final String PROPERTY = "legs";
    private static final int VALUE = 42;
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fileSystemRule.get());
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.fileSystemRule);

    @Test
    public void migrateLatestStandardToLatestHighLimit() throws Exception {
        RecordFormatsMigrationIT.executeAndStopDb(this.startStandardFormatDb(), RecordFormatsMigrationIT::createNode);
        this.assertLatestStandardStore();
        RecordFormatsMigrationIT.executeAndStopDb(this.startHighLimitFormatDb(), RecordFormatsMigrationIT::assertNodeExists);
        this.assertLatestHighLimitStore();
    }

    @Test
    public void migrateHighLimitV3_0ToLatestHighLimit() throws Exception {
        RecordFormatsMigrationIT.executeAndStopDb(this.startDb("high_limitV3_0_0"), RecordFormatsMigrationIT::createNode);
        this.assertStoreFormat(HighLimitV3_0_0.RECORD_FORMATS);
        RecordFormatsMigrationIT.executeAndStopDb(this.startHighLimitFormatDb(), RecordFormatsMigrationIT::assertNodeExists);
        this.assertLatestHighLimitStore();
    }

    @Test
    public void migrateHighLimitToStandard() throws Exception {
        RecordFormatsMigrationIT.executeAndStopDb(this.startHighLimitFormatDb(), RecordFormatsMigrationIT::createNode);
        this.assertLatestHighLimitStore();
        try {
            this.startStandardFormatDb();
            Assert.fail((String)"Should not be possible to downgrade");
        }
        catch (Exception e) {
            Assert.assertThat((Object)Exceptions.rootCause((Throwable)e), (Matcher)Matchers.instanceOf(StoreUpgrader.UnexpectedUpgradingStoreFormatException.class));
        }
        this.assertLatestHighLimitStore();
    }

    private static void createNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node start = db.createNode(new Label[]{LABEL});
            start.setProperty(PROPERTY, (Object)42);
            tx.success();
        }
    }

    private static void assertNodeExists(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Assert.assertNotNull((Object)db.findNode(LABEL, PROPERTY, (Object)42));
            tx.success();
        }
    }

    private GraphDatabaseService startStandardFormatDb() {
        return this.startDb("standard");
    }

    private GraphDatabaseService startHighLimitFormatDb() {
        return this.startDb("high_limit");
    }

    private GraphDatabaseService startDb(String recordFormatName) {
        return new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDirectory.databaseDir()).setConfig(GraphDatabaseSettings.allow_upgrade, "true").setConfig(GraphDatabaseSettings.record_format, recordFormatName).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
    }

    private void assertLatestStandardStore() throws Exception {
        this.assertStoreFormat(Standard.LATEST_RECORD_FORMATS);
    }

    private void assertLatestHighLimitStore() throws Exception {
        this.assertStoreFormat(HighLimit.RECORD_FORMATS);
    }

    private void assertStoreFormat(RecordFormats expected) throws Exception {
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)"8m");
        try (ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();
             PageCache pageCache = ConfigurableStandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fileSystemRule.get(), (Config)config, (JobScheduler)jobScheduler);){
            RecordFormats actual = RecordFormatSelector.selectForStoreOrConfig((Config)config, (DatabaseLayout)this.testDirectory.databaseLayout(), (FileSystemAbstraction)this.fileSystemRule, (PageCache)pageCache, (LogProvider)NullLogProvider.getInstance());
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((Object)expected.storeVersion(), (Object)actual.storeVersion());
        }
    }

    private static void executeAndStopDb(GraphDatabaseService db, Consumer<GraphDatabaseService> action) {
        try {
            action.accept(db);
        }
        finally {
            db.shutdown();
        }
    }
}

