/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EnterpriseDatabaseRule;

public class ProcedureResourcesIT {
    @Rule
    public DatabaseRule db = new EnterpriseDatabaseRule().withSetting(OnlineBackupSettings.online_backup_enabled, "false");
    private final String indexDefinition = ":Label(prop)";
    private final String explicitIndexName = "explicitIndex";
    private final String relExplicitIndexName = "relExplicitIndex";
    private final String ftsNodesIndex = "'ftsNodes'";
    private final String ftsRelsIndex = "'ftsRels'";
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    @After
    public void tearDown() throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(5L, TimeUnit.SECONDS);
    }

    @Test
    public void allProcedures() throws Exception {
        this.createIndex();
        this.createExplicitIndex();
        this.createFulltextIndexes();
        for (ProcedureSignature procedure : ((Procedures)this.db.getDependencyResolver().resolveDependency(Procedures.class)).getAllProcedures()) {
            this.initialData();
            ProcedureData procedureData = null;
            try {
                procedureData = this.procedureDataFor(procedure);
                this.verifyProcedureCloseAllAcquiredKernelStatements(procedureData);
            }
            catch (Exception e) {
                throw new Exception("Failed on procedure: \"" + procedureData + "\"", e);
            }
            this.clearDb();
        }
    }

    private void initialData() {
        Label unusedLabel = Label.label((String)"unusedLabel");
        RelationshipType unusedRelType = RelationshipType.withName((String)"unusedRelType");
        String unusedPropKey = "unusedPropKey";
        try (Transaction tx = this.db.beginTx();){
            Node node1 = this.db.createNode(new Label[]{unusedLabel});
            node1.setProperty(unusedPropKey, (Object)"value");
            Node node2 = this.db.createNode(new Label[]{unusedLabel});
            node2.setProperty(unusedPropKey, (Object)1);
            node1.createRelationshipTo(node2, unusedRelType);
            tx.success();
        }
    }

    private void verifyProcedureCloseAllAcquiredKernelStatements(ProcedureData proc) throws ExecutionException, InterruptedException {
        if (proc.skip) {
            return;
        }
        String failureMessage = "Failed on procedure " + proc.name;
        try (Transaction outer = this.db.beginTx();){
            String procedureQuery = proc.buildProcedureQuery();
            this.exhaust(this.db.execute(procedureQuery)).close();
            this.exhaust(this.db.execute("MATCH (mo:Label) WHERE mo.prop = 'n/a' RETURN mo")).close();
            this.executeInOtherThread("CREATE(mo:Label) SET mo.prop = 'val' RETURN mo");
            Result result = this.db.execute("MATCH (mo:Label) WHERE mo.prop = 'val' RETURN mo");
            Assert.assertTrue((String)failureMessage, (boolean)result.hasNext());
            Map next = result.next();
            Assert.assertNotNull((String)failureMessage, next.get("mo"));
            this.exhaust(result);
            result.close();
            outer.success();
        }
    }

    private Result exhaust(Result execute) {
        while (execute.hasNext()) {
            execute.next();
        }
        return execute;
    }

    private void createIndex() {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("CREATE INDEX ON :Label(prop)");
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.schema().awaitIndexesOnline(5L, TimeUnit.SECONDS);
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private void createFulltextIndexes() {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("call db.index.fulltext.createNodeIndex('ftsNodes', ['Label'], ['prop'])").close();
            this.db.execute("call db.index.fulltext.createRelationshipIndex('ftsRels', ['Label'], ['prop'])").close();
            tx.success();
        }
    }

    private void createExplicitIndex() {
        try (Transaction tx = this.db.beginTx();){
            this.db.index().forNodes("explicitIndex");
            this.db.index().forRelationships("relExplicitIndex");
            tx.success();
        }
    }

    private void clearDb() {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("MATCH (n) DETACH DELETE n").close();
            tx.success();
        }
    }

    private ProcedureData procedureDataFor(ProcedureSignature procedure) {
        ProcedureData proc = new ProcedureData(procedure);
        switch (proc.name) {
            case "db.createProperty": {
                proc.withParam("'propKey'");
                break;
            }
            case "db.resampleIndex": {
                proc.withParam("':Label(prop)'");
                break;
            }
            case "db.createRelationshipType": {
                proc.withParam("'RelType'");
                break;
            }
            case "dbms.queryJmx": {
                proc.withParam("'*:*'");
                break;
            }
            case "db.awaitIndex": {
                proc.withParam("':Label(prop)'");
                proc.withParam(100);
                break;
            }
            case "db.createLabel": {
                proc.withParam("'OtherLabel'");
                break;
            }
            case "dbms.killQuery": {
                proc.withParam("'query-1234'");
                break;
            }
            case "dbms.killQueries": {
                proc.withParam("['query-1234']");
                break;
            }
            case "dbms.killConnection": {
                proc.withParam("'bolt-1234'");
                break;
            }
            case "dbms.killConnections": {
                proc.withParam("['bolt-1234']");
                break;
            }
            case "dbms.setTXMetaData": {
                proc.withParam("{realUser:'MyMan'}");
                break;
            }
            case "dbms.listActiveLocks": {
                proc.withParam("'query-1234'");
                break;
            }
            case "db.index.explicit.seekNodes": {
                proc.withParam("'explicitIndex'");
                proc.withParam("'noKey'");
                proc.withParam("'noValue'");
                break;
            }
            case "db.index.explicit.searchNodes": {
                proc.withParam("'explicitIndex'");
                proc.withParam("'noKey:foo*'");
                break;
            }
            case "db.index.explicit.searchRelationships": {
                proc.withParam("'relExplicitIndex'");
                proc.withParam("'noKey:foo*'");
                break;
            }
            case "db.index.explicit.searchRelationshipsIn": {
                proc.withParam("'relExplicitIndex'");
                proc.withParam("n");
                proc.withParam("'noKey:foo*'");
                proc.withSetup("OPTIONAL MATCH (n) WITH n LIMIT 1", "YIELD relationship AS r RETURN r");
                break;
            }
            case "db.index.explicit.searchRelationshipsOut": {
                proc.withParam("'relExplicitIndex'");
                proc.withParam("n");
                proc.withParam("'noKey:foo*'");
                proc.withSetup("OPTIONAL MATCH (n) WITH n LIMIT 1", "YIELD relationship AS r RETURN r");
                break;
            }
            case "db.index.explicit.searchRelationshipsBetween": {
                proc.withParam("'relExplicitIndex'");
                proc.withParam("n");
                proc.withParam("n");
                proc.withParam("'noKey:foo*'");
                proc.withSetup("OPTIONAL MATCH (n) WITH n LIMIT 1", "YIELD relationship AS r RETURN r");
                break;
            }
            case "db.index.explicit.seekRelationships": {
                proc.withParam("'relExplicitIndex'");
                proc.withParam("'noKey'");
                proc.withParam("'noValue'");
                break;
            }
            case "db.index.explicit.auto.seekNodes": {
                proc.withParam("'noKey'");
                proc.withParam("'noValue'");
                break;
            }
            case "db.index.explicit.auto.searchNodes": {
                proc.withParam("'noKey:foo*'");
                break;
            }
            case "db.index.explicit.auto.searchRelationships": {
                proc.withParam("'noKey:foo*'");
                break;
            }
            case "db.index.explicit.auto.seekRelationships": {
                proc.withParam("'noKey'");
                proc.withParam("'noValue'");
                break;
            }
            case "db.index.explicit.existsForNodes": {
                proc.withParam("'explicitIndex'");
                break;
            }
            case "db.index.explicit.existsForRelationships": {
                proc.withParam("'explicitIndex'");
                break;
            }
            case "db.index.explicit.forNodes": {
                proc.withParam("'explicitIndex'");
                break;
            }
            case "db.index.explicit.forRelationships": {
                proc.withParam("'explicitIndex'");
                break;
            }
            case "db.index.explicit.addNode": {
                proc.withParam("'explicitIndex'");
                proc.withParam("n");
                proc.withParam("'prop'");
                proc.withParam("'value'");
                proc.withSetup("OPTIONAL MATCH (n) WITH n LIMIT 1", "YIELD success RETURN success");
                break;
            }
            case "db.index.explicit.addRelationship": {
                proc.withParam("'explicitIndex'");
                proc.withParam("r");
                proc.withParam("'prop'");
                proc.withParam("'value'");
                proc.withSetup("OPTIONAL MATCH ()-[r]->() WITH r LIMIT 1", "YIELD success RETURN success");
                break;
            }
            case "db.index.explicit.removeNode": {
                proc.withParam("'explicitIndex'");
                proc.withParam("n");
                proc.withParam("'prop'");
                proc.withSetup("OPTIONAL MATCH (n) WITH n LIMIT 1", "YIELD success RETURN success");
                break;
            }
            case "db.index.explicit.removeRelationship": {
                proc.withParam("'explicitIndex'");
                proc.withParam("r");
                proc.withParam("'prop'");
                proc.withSetup("OPTIONAL MATCH ()-[r]->() WITH r LIMIT 1", "YIELD success RETURN success");
                break;
            }
            case "db.index.explicit.drop": {
                proc.withParam("'explicitIndex'");
                break;
            }
            case "dbms.setConfigValue": {
                proc.withParam("'dbms.logs.query.enabled'");
                proc.withParam("'false'");
                break;
            }
            case "db.createIndex": {
                proc.withParam("':Person(name)'");
                proc.withParam("'lucene+native-2.0'");
                break;
            }
            case "db.createNodeKey": {
                proc.skip = true;
                break;
            }
            case "db.createUniquePropertyConstraint": {
                proc.skip = true;
                break;
            }
            case "db.index.fulltext.queryNodes": {
                proc.withParam("'ftsNodes'");
                proc.withParam("'value'");
                break;
            }
            case "db.index.fulltext.queryRelationships": {
                proc.withParam("'ftsRels'");
                proc.withParam("'value'");
                break;
            }
            case "db.index.fulltext.drop": {
                proc.withParam("'ftsRels'");
                break;
            }
            case "db.index.fulltext.createRelationshipIndex": {
                proc.skip = true;
                break;
            }
            case "db.index.fulltext.createNodeIndex": {
                proc.skip = true;
                break;
            }
        }
        return proc;
    }

    private void executeInOtherThread(String query) throws ExecutionException, InterruptedException {
        Future<?> future = this.executor.submit(() -> {
            try (Transaction tx = this.db.beginTx();){
                this.exhaust(this.db.execute(query));
                tx.success();
            }
        });
        future.get();
    }

    private static class ProcedureData {
        private final String name;
        private final List<Object> params = new ArrayList<Object>();
        private String setupQuery;
        private String postQuery;
        private boolean skip;

        private ProcedureData(ProcedureSignature procedure) {
            this.name = procedure.name().toString();
        }

        private void withParam(Object param) {
            this.params.add(param);
        }

        private void withSetup(String setupQuery, String postQuery) {
            this.setupQuery = setupQuery;
            this.postQuery = postQuery;
        }

        private String buildProcedureQuery() {
            StringJoiner stringJoiner = new StringJoiner(",", "CALL " + this.name + "(", ")");
            for (Object parameter : this.params) {
                stringJoiner.add(parameter.toString());
            }
            if (this.setupQuery != null && this.postQuery != null) {
                return this.setupQuery + " " + stringJoiner.toString() + " " + this.postQuery;
            }
            return stringJoiner.toString();
        }

        public String toString() {
            return this.buildProcedureQuery();
        }
    }
}

