/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.logging.internal.SimpleLogService;
import org.neo4j.metrics.MetricsExtension;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

public class BatchingNeoStoresIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private FileSystemAbstraction fileSystem;
    private File databaseDirectory;
    private AssertableLogProvider provider;
    private SimpleLogService logService;

    @Before
    public void setUp() {
        this.fileSystem = this.fileSystemRule.get();
        this.databaseDirectory = this.testDirectory.databaseDir();
        this.provider = new AssertableLogProvider();
        this.logService = new SimpleLogService((LogProvider)this.provider, (LogProvider)this.provider);
    }

    @Test
    public void startBatchingNeoStoreWithMetricsPluginEnabled() throws Exception {
        Config config = Config.defaults((Setting)MetricsSettings.metricsEnabled, (String)"true");
        try (ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();
             BatchingNeoStores batchingNeoStores = BatchingNeoStores.batchingNeoStores((FileSystemAbstraction)this.fileSystem, (File)this.databaseDirectory, (RecordFormats)RecordFormatSelector.defaultFormat(), (Configuration)Configuration.DEFAULT, (LogService)this.logService, (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)config, (JobScheduler)jobScheduler);){
            batchingNeoStores.createNew();
        }
        this.provider.assertNone(AssertableLogProvider.inLog(MetricsExtension.class).any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createStoreWithNotEmptyInitialIds() throws Exception {
        try (ThreadPoolJobScheduler jobScheduler = new ThreadPoolJobScheduler();
             BatchingNeoStores batchingNeoStores = BatchingNeoStores.batchingNeoStores((FileSystemAbstraction)this.fileSystem, (File)this.databaseDirectory, (RecordFormats)RecordFormatSelector.defaultFormat(), (Configuration)Configuration.DEFAULT, (LogService)this.logService, (AdditionalInitialIds)new TestAdditionalInitialIds(), (Config)Config.defaults(), (JobScheduler)jobScheduler);){
            batchingNeoStores.createNew();
        }
        GraphDatabaseService database = new EnterpriseGraphDatabaseFactory().newEmbeddedDatabase(this.databaseDirectory);
        try {
            TransactionIdStore transactionIdStore = BatchingNeoStoresIT.getTransactionIdStore((GraphDatabaseAPI)database);
            Assert.assertEquals((long)10L, (long)transactionIdStore.getLastCommittedTransactionId());
        }
        finally {
            database.shutdown();
        }
    }

    private static TransactionIdStore getTransactionIdStore(GraphDatabaseAPI database) {
        DependencyResolver resolver = database.getDependencyResolver();
        return (TransactionIdStore)resolver.resolveDependency(TransactionIdStore.class);
    }

    private static class TestAdditionalInitialIds
    implements AdditionalInitialIds {
        private TestAdditionalInitialIds() {
        }

        public long lastCommittedTransactionId() {
            return 10L;
        }

        public long lastCommittedTransactionChecksum() {
            return 11L;
        }

        public long lastCommittedTransactionLogVersion() {
            return 12L;
        }

        public long lastCommittedTransactionLogByteOffset() {
            return 13L;
        }
    }
}

