/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.collection.RawIterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.internal.kernel.api.IndexOrder;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.exceptions.schema.UniquePropertyValueValidationException;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@RunWith(value=Parameterized.class)
public class EnterpriseCreateIndexProcedureIT
extends KernelIntegrationTest {
    @Parameterized.Parameter
    public static boolean existenceConstraint;
    @Parameterized.Parameter(value=1)
    public static boolean uniquenessConstraint;
    @Parameterized.Parameter(value=2)
    public static String indexProcedureName;
    @Parameterized.Parameter(value=3)
    public static String expectedSuccessfulCreationStatus;

    @Parameterized.Parameters(name="{2}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({false, false, "createIndex", "index created"}, {false, true, "createUniquePropertyConstraint", "uniqueness constraint online"}, {true, true, "createNodeKey", "node key constraint online"});
    }

    @Test
    public void createIndexWithGivenProvider() throws KernelException {
        this.testCreateIndexWithGivenProvider("Person", "name");
    }

    @Test
    public void createIndexWithGivenProviderComposite() throws KernelException {
        this.testCreateIndexWithGivenProvider("NinjaTurtle", "favoritePizza", "favoriteBrother");
    }

    @Test
    public void shouldCreateNonExistingLabelAndPropertyToken() throws Exception {
        String label = "MyLabel";
        String propKey = "myKey";
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.read());
        Assert.assertEquals((String)"label token should not exist", (long)-1L, (long)transaction.tokenRead().nodeLabel(label));
        Assert.assertEquals((String)"property token should not exist", (long)-1L, (long)transaction.tokenRead().propertyKey(propKey));
        this.commit();
        this.newTransaction((LoginContext)AnonymousContext.full());
        this.callIndexProcedure(this.indexPattern(label, propKey), GraphDatabaseSettings.SchemaIndex.NATIVE20.providerName());
        this.commit();
        transaction = this.newTransaction((LoginContext)AnonymousContext.read());
        Assert.assertNotEquals((String)"label token should exist", (long)-1L, (long)transaction.tokenRead().nodeLabel(label));
        Assert.assertNotEquals((String)"property token should exist", (long)-1L, (long)transaction.tokenRead().propertyKey(propKey));
    }

    @Test
    public void throwIfNullProvider() throws Exception {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        transaction.tokenWrite().labelGetOrCreateForName("Person");
        this.createProperties(transaction, "name");
        this.commit();
        this.newTransaction((LoginContext)AnonymousContext.full());
        String pattern = this.indexPattern("Person", "name");
        ProcedureException e = (ProcedureException)Assertions.assertThrows(ProcedureException.class, () -> this.callIndexProcedure(pattern, null));
        Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Could not create index with specified index provider being null"));
        this.commit();
    }

    @Test
    public void throwIfNonExistingProvider() throws Exception {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        transaction.tokenWrite().labelGetOrCreateForName("Person");
        this.createProperties(transaction, "name");
        this.commit();
        this.newTransaction((LoginContext)AnonymousContext.full());
        String pattern = this.indexPattern("Person", "name");
        try {
            this.callIndexProcedure(pattern, "non+existing-1.0");
            Assert.fail((String)"Expected to fail");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"Failed to invoke procedure"), (Matcher)Matchers.containsString((String)"Tried to get index provider"), (Matcher)Matchers.containsString((String)"available providers in this session being"), (Matcher)Matchers.containsString((String)"default being")));
        }
    }

    @Test
    public void throwIfIndexAlreadyExists() throws Exception {
        String label = "Superhero";
        String propertyKey = "primaryPower";
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            this.db.schema().indexFor(Label.label((String)label)).on(propertyKey).create();
            tx.success();
        }
        this.awaitIndexOnline();
        this.newTransaction((LoginContext)AnonymousContext.full());
        String pattern = this.indexPattern(label, propertyKey);
        try {
            this.callIndexProcedure(pattern, GraphDatabaseSettings.SchemaIndex.NATIVE20.providerName());
            Assert.fail((String)"Should have failed");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"There already exists an index "));
        }
    }

    private int[] createProperties(Transaction transaction, String ... properties) throws IllegalTokenNameException {
        int[] propertyKeyIds = new int[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            propertyKeyIds[i] = transaction.tokenWrite().propertyKeyGetOrCreateForName(properties[i]);
        }
        return propertyKeyIds;
    }

    private long createNodeWithPropertiesAndLabel(Transaction transaction, int labelId, int[] propertyKeyIds, TextValue value) throws KernelException {
        long node = transaction.dataWrite().nodeCreate();
        transaction.dataWrite().nodeAddLabel(node, labelId);
        for (int propertyKeyId : propertyKeyIds) {
            transaction.dataWrite().nodeSetProperty(node, propertyKeyId, (Value)value);
        }
        return node;
    }

    private String indexPattern(String label, String ... properties) {
        StringJoiner pattern = new StringJoiner(",", ":" + label + "(", ")");
        for (String property : properties) {
            pattern.add(property);
        }
        return pattern.toString();
    }

    private RawIterator<Object[], ProcedureException> callIndexProcedure(String pattern, String specifiedProvider) throws ProcedureException, TransactionFailureException {
        return this.procsSchema().procedureCallSchema(ProcedureSignature.procedureName((String[])new String[]{"db", indexProcedureName}), new Object[]{pattern, specifiedProvider});
    }

    private void awaitIndexOnline() {
        try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
            this.db.schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
    }

    private void testCreateIndexWithGivenProvider(String label, String ... properties) throws KernelException {
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int labelId = transaction.tokenWrite().labelGetOrCreateForName(label);
        int[] propertyKeyIds = this.createProperties(transaction, properties);
        TextValue value = Values.stringValue((String)"some value");
        long node = this.createNodeWithPropertiesAndLabel(transaction, labelId, propertyKeyIds, value);
        this.commit();
        this.newTransaction((LoginContext)AnonymousContext.full());
        String pattern = this.indexPattern(label, properties);
        String specifiedProvider = GraphDatabaseSettings.SchemaIndex.NATIVE10.providerName();
        RawIterator<Object[], ProcedureException> result = this.callIndexProcedure(pattern, specifiedProvider);
        Assert.assertThat(Arrays.asList((Object[])result.next()), (Matcher)Matchers.contains((Object[])new Object[]{pattern, specifiedProvider, expectedSuccessfulCreationStatus}));
        this.commit();
        this.awaitIndexOnline();
        transaction = this.newTransaction((LoginContext)AnonymousContext.read());
        SchemaRead schemaRead = transaction.schemaRead();
        IndexReference index = schemaRead.index(labelId, propertyKeyIds);
        this.assertCorrectIndex(labelId, propertyKeyIds, uniquenessConstraint, index);
        this.assertIndexData(transaction, propertyKeyIds, value, node, index);
        this.commit();
    }

    private void assertIndexData(Transaction transaction, int[] propertyKeyIds, TextValue value, long node, IndexReference index) throws KernelException {
        try (NodeValueIndexCursor indexCursor = transaction.cursors().allocateNodeValueIndexCursor();){
            IndexQuery[] query = new IndexQuery[propertyKeyIds.length];
            for (int i = 0; i < propertyKeyIds.length; ++i) {
                query[i] = IndexQuery.exact((int)propertyKeyIds[i], (Object)value);
            }
            transaction.dataRead().nodeIndexSeek(index, indexCursor, IndexOrder.NONE, false, query);
            Assert.assertTrue((boolean)indexCursor.next());
            Assert.assertEquals((long)node, (long)indexCursor.nodeReference());
            Assert.assertFalse((boolean)indexCursor.next());
        }
    }

    private void assertCorrectIndex(int labelId, int[] propertyKeyIds, boolean expectedUnique, IndexReference index) {
        Assert.assertEquals((String)"provider key", (Object)"lucene+native", (Object)index.providerKey());
        Assert.assertEquals((String)"provider version", (Object)"1.0", (Object)index.providerVersion());
        Assert.assertEquals((Object)expectedUnique, (Object)index.isUnique());
        Assert.assertEquals((String)"label id", (long)labelId, (long)index.schema().getEntityTokenIds()[0]);
        for (int i = 0; i < propertyKeyIds.length; ++i) {
            Assert.assertEquals((String)"property key id", (long)propertyKeyIds[i], (long)index.properties()[i]);
        }
    }

    @Test
    public void throwOnUniquenessViolation() throws Exception {
        this.testThrowOnUniquenessViolation("MyLabel", "oneKey");
    }

    @Test
    public void throwOnUniquenessViolationComposite() throws Exception {
        this.testThrowOnUniquenessViolation("MyLabel", "oneKey", "anotherKey");
    }

    @Test
    public void throwOnNonUniqueStore() throws Exception {
        Assume.assumeThat((String)"Only relevant for uniqueness constraints", (Object)uniquenessConstraint, (Matcher)CoreMatchers.is((Object)true));
        String label = "SomeLabel";
        String[] properties = new String[]{"key1", "key2"};
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int labelId = transaction.tokenWrite().labelGetOrCreateForName(label);
        int[] propertyKeyIds = this.createProperties(transaction, properties);
        TextValue value = Values.stringValue((String)"some value");
        this.createNodeWithPropertiesAndLabel(transaction, labelId, propertyKeyIds, value);
        this.createNodeWithPropertiesAndLabel(transaction, labelId, propertyKeyIds, value);
        this.commit();
        try {
            this.createConstraint(label, properties);
            Assert.fail((String)"Should have failed");
        }
        catch (ProcedureException e) {
            Assert.assertThat((Object)Exceptions.rootCause((Throwable)e), (Matcher)Matchers.instanceOf(UniquePropertyValueValidationException.class));
        }
    }

    @Test
    public void throwOnExistenceViolation() throws Exception {
        Assume.assumeThat((String)"Only relevant for existence constraints", (Object)existenceConstraint, (Matcher)CoreMatchers.is((Object)true));
        String label = "label";
        String prop = "key";
        this.createConstraint(label, prop);
        try {
            try (org.neo4j.graphdb.Transaction tx = this.db.beginTx();){
                this.db.createNode(new Label[]{Label.label((String)label)});
                tx.success();
            }
            Assert.fail((String)"Should have failed");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    private void testThrowOnUniquenessViolation(String label, String ... properties) throws Exception {
        Assume.assumeThat((String)"Only relevant for uniqueness constraints", (Object)uniquenessConstraint, (Matcher)CoreMatchers.is((Object)true));
        Transaction transaction = this.newTransaction((LoginContext)AnonymousContext.writeToken());
        int labelId = transaction.tokenWrite().labelGetOrCreateForName(label);
        int[] propertyKeyIds = this.createProperties(transaction, properties);
        TextValue value = Values.stringValue((String)"some value");
        this.createNodeWithPropertiesAndLabel(transaction, labelId, propertyKeyIds, value);
        this.commit();
        this.createConstraint(label, properties);
        try {
            transaction = this.newTransaction((LoginContext)AnonymousContext.write());
            this.createNodeWithPropertiesAndLabel(transaction, labelId, propertyKeyIds, value);
            Assert.fail((String)"Should have failed");
        }
        catch (UniquePropertyValueValidationException uniquePropertyValueValidationException) {
            // empty catch block
        }
    }

    private void createConstraint(String label, String ... properties) throws TransactionFailureException, ProcedureException {
        this.newTransaction((LoginContext)AnonymousContext.full());
        String pattern = this.indexPattern(label, properties);
        String specifiedProvider = GraphDatabaseSettings.SchemaIndex.NATIVE10.providerName();
        this.callIndexProcedure(pattern, specifiedProvider);
        this.commit();
    }

    protected TestGraphDatabaseFactory createGraphDatabaseFactory() {
        return new TestEnterpriseGraphDatabaseFactory();
    }
}

