/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.enterprise.configuration.OnlineBackupSettings;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class StartOnExistingDbWithIndexIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void startStopDatabaseWithIndex() {
        Label label = Label.label((String)"string");
        String property = "property";
        AssertableLogProvider logProvider = new AssertableLogProvider(true);
        GraphDatabaseService db = this.prepareDb(label, property, (LogProvider)logProvider);
        db.shutdown();
        db = this.getDatabase((LogProvider)logProvider);
        db.shutdown();
        logProvider.assertNoMessagesContaining("Failed to open index");
    }

    private GraphDatabaseService prepareDb(Label label, String propertyName, LogProvider logProvider) {
        GraphDatabaseService db = this.getDatabase(logProvider);
        try (Transaction transaction = db.beginTx();){
            db.schema().constraintFor(label).assertPropertyIsUnique(propertyName).create();
            transaction.success();
        }
        StartOnExistingDbWithIndexIT.waitIndexes(db);
        return db;
    }

    private GraphDatabaseService getDatabase(LogProvider logProvider) {
        return new TestEnterpriseGraphDatabaseFactory().setInternalLogProvider(logProvider).newEmbeddedDatabaseBuilder(this.testDirectory.storeDir()).setConfig(OnlineBackupSettings.online_backup_enabled, "false").newGraphDatabase();
    }

    private static void waitIndexes(GraphDatabaseService db) {
        try (Transaction transaction = db.beginTx();){
            db.schema().awaitIndexesOnline(5L, TimeUnit.SECONDS);
            transaction.success();
        }
    }
}

