/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageEngine;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.test.Barrier;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.TestLabels;
import org.neo4j.test.rule.concurrent.OtherThreadRule;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class HalfAppliedConstraintRecoveryIT {
    private static final Label LABEL = TestLabels.LABEL_ONE;
    private static final String KEY = "key";
    private static final String KEY2 = "key2";
    private static final Consumer<GraphDatabaseAPI> UNIQUE_CONSTRAINT_CREATOR = db -> db.schema().constraintFor(LABEL).assertPropertyIsUnique(KEY).create();
    private static final Consumer<GraphDatabaseAPI> NODE_KEY_CONSTRAINT_CREATOR = db -> db.execute("CREATE CONSTRAINT ON (n:" + LABEL.name() + ") ASSERT (n." + KEY + ") IS NODE KEY");
    private static final Consumer<GraphDatabaseAPI> COMPOSITE_NODE_KEY_CONSTRAINT_CREATOR = db -> db.execute("CREATE CONSTRAINT ON (n:" + LABEL.name() + ") ASSERT (n." + KEY + ", n." + KEY2 + ") IS NODE KEY");
    private static final BiConsumer<GraphDatabaseAPI, List<TransactionRepresentation>> REAPPLY = (db, txs) -> HalfAppliedConstraintRecoveryIT.apply(db, txs.subList(txs.size() - 1, txs.size()));
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule("T2");
    private final Monitors monitors = new Monitors();

    private static BiConsumer<GraphDatabaseAPI, List<TransactionRepresentation>> recreate(Consumer<GraphDatabaseAPI> constraintCreator) {
        return (db, txs) -> HalfAppliedConstraintRecoveryIT.createConstraint(db, constraintCreator);
    }

    @Test
    public void recoverFromAndContinueApplyHalfConstraintAppliedBeforeCrash() throws Exception {
        this.recoverFromHalfConstraintAppliedBeforeCrash(REAPPLY, UNIQUE_CONSTRAINT_CREATOR, false);
    }

    @Test
    public void recoverFromAndRecreateHalfConstraintAppliedBeforeCrash() throws Exception {
        this.recoverFromHalfConstraintAppliedBeforeCrash(HalfAppliedConstraintRecoveryIT.recreate(UNIQUE_CONSTRAINT_CREATOR), UNIQUE_CONSTRAINT_CREATOR, false);
    }

    @Test
    public void recoverFromAndContinueApplyHalfNodeKeyConstraintAppliedBeforeCrash() throws Exception {
        this.recoverFromHalfConstraintAppliedBeforeCrash(REAPPLY, NODE_KEY_CONSTRAINT_CREATOR, false);
    }

    @Test
    public void recoverFromAndRecreateHalfNodeKeyConstraintAppliedBeforeCrash() throws Exception {
        this.recoverFromHalfConstraintAppliedBeforeCrash(HalfAppliedConstraintRecoveryIT.recreate(NODE_KEY_CONSTRAINT_CREATOR), NODE_KEY_CONSTRAINT_CREATOR, false);
    }

    @Test
    public void recoverFromAndContinueApplyHalfCompositeNodeKeyConstraintAppliedBeforeCrash() throws Exception {
        this.recoverFromHalfConstraintAppliedBeforeCrash(REAPPLY, COMPOSITE_NODE_KEY_CONSTRAINT_CREATOR, true);
    }

    @Test
    public void recoverFromAndRecreateHalfCompositeNodeKeyConstraintAppliedBeforeCrash() throws Exception {
        this.recoverFromHalfConstraintAppliedBeforeCrash(HalfAppliedConstraintRecoveryIT.recreate(COMPOSITE_NODE_KEY_CONSTRAINT_CREATOR), COMPOSITE_NODE_KEY_CONSTRAINT_CREATOR, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverFromHalfConstraintAppliedBeforeCrash(BiConsumer<GraphDatabaseAPI, List<TransactionRepresentation>> applier, Consumer<GraphDatabaseAPI> constraintCreator, boolean composite) throws Exception {
        EphemeralFileSystemAbstraction crashSnapshot;
        List<TransactionRepresentation> transactions = HalfAppliedConstraintRecoveryIT.createTransactionsForCreatingConstraint(constraintCreator);
        GraphDatabaseAPI db = this.newDb();
        try {
            HalfAppliedConstraintRecoveryIT.apply(db, transactions.subList(0, transactions.size() - 1));
            HalfAppliedConstraintRecoveryIT.flushStores(db);
            crashSnapshot = this.fs.snapshot();
        }
        finally {
            db.shutdown();
        }
        db = (GraphDatabaseAPI)new TestEnterpriseGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)crashSnapshot).newImpermanentDatabase();
        try {
            applier.accept(db, transactions);
            try (Transaction tx = db.beginTx();){
                ConstraintDefinition constraint = (ConstraintDefinition)Iterables.single((Iterable)db.schema().getConstraints(LABEL));
                Assert.assertEquals((Object)LABEL.name(), (Object)constraint.getLabel().name());
                if (composite) {
                    Assert.assertEquals(Arrays.asList(KEY, KEY2), (Object)Iterables.asList((Iterable)constraint.getPropertyKeys()));
                } else {
                    Assert.assertEquals((Object)KEY, (Object)Iterables.single((Iterable)constraint.getPropertyKeys()));
                }
                IndexDefinition index = (IndexDefinition)Iterables.single((Iterable)db.schema().getIndexes(LABEL));
                Assert.assertEquals((Object)LABEL.name(), (Object)index.getLabel().name());
                if (composite) {
                    Assert.assertEquals(Arrays.asList(KEY, KEY2), (Object)Iterables.asList((Iterable)index.getPropertyKeys()));
                } else {
                    Assert.assertEquals((Object)KEY, (Object)Iterables.single((Iterable)index.getPropertyKeys()));
                }
                tx.success();
            }
        }
        finally {
            db.shutdown();
        }
    }

    @Test
    public void recoverFromNonUniqueHalfConstraintAppliedBeforeCrash() throws Exception {
        this.recoverFromConstraintAppliedBeforeCrash(UNIQUE_CONSTRAINT_CREATOR);
    }

    @Test
    public void recoverFromNonUniqueHalfNodeKeyConstraintAppliedBeforeCrash() throws Exception {
        this.recoverFromConstraintAppliedBeforeCrash(NODE_KEY_CONSTRAINT_CREATOR);
    }

    @Test
    public void recoverFromNonUniqueHalfCompositeNodeKeyConstraintAppliedBeforeCrash() throws Exception {
        this.recoverFromConstraintAppliedBeforeCrash(COMPOSITE_NODE_KEY_CONSTRAINT_CREATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverFromConstraintAppliedBeforeCrash(Consumer<GraphDatabaseAPI> constraintCreator) throws Exception {
        EphemeralFileSystemAbstraction crashSnapshot;
        List<TransactionRepresentation> transactions = HalfAppliedConstraintRecoveryIT.createTransactionsForCreatingConstraint(constraintCreator);
        GraphDatabaseAPI db = this.newDb();
        final Barrier.Control barrier = new Barrier.Control();
        this.monitors.addMonitorListener((Object)new IndexingService.MonitorAdapter(){

            public void indexPopulationScanComplete() {
                barrier.reached();
            }
        }, new String[0]);
        try {
            String value = "v";
            try (Transaction tx = db.beginTx();){
                for (int i = 0; i < 2; ++i) {
                    db.createNode(new Label[]{LABEL}).setProperty(KEY, (Object)value);
                }
                tx.success();
            }
            this.t2.execute(state -> {
                HalfAppliedConstraintRecoveryIT.apply(db, transactions.subList(0, transactions.size() - 1));
                return null;
            });
            barrier.await();
            HalfAppliedConstraintRecoveryIT.flushStores(db);
            crashSnapshot = this.fs.snapshot();
            barrier.release();
        }
        finally {
            db.shutdown();
        }
        db = (GraphDatabaseAPI)new TestEnterpriseGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)crashSnapshot).newImpermanentDatabase();
        try {
            HalfAppliedConstraintRecoveryIT.recreate(constraintCreator).accept(db, transactions);
            Assert.fail((String)"Should not be able to create constraint on non-unique data");
        }
        catch (ConstraintViolationException | QueryExecutionException throwable) {
        }
        finally {
            db.shutdown();
        }
    }

    private GraphDatabaseAPI newDb() {
        return (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs).setMonitors(this.monitors).newImpermanentDatabase();
    }

    private static void flushStores(GraphDatabaseAPI db) {
        ((RecordStorageEngine)db.getDependencyResolver().resolveDependency(RecordStorageEngine.class)).testAccessNeoStores().flush(IOLimiter.unlimited());
    }

    private static void apply(GraphDatabaseAPI db, List<TransactionRepresentation> transactions) {
        TransactionCommitProcess committer = (TransactionCommitProcess)db.getDependencyResolver().resolveDependency(TransactionCommitProcess.class);
        transactions.forEach(tx -> {
            try {
                committer.commit(new TransactionToApply(tx), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
            }
            catch (TransactionFailureException e) {
                throw new RuntimeException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<TransactionRepresentation> createTransactionsForCreatingConstraint(Consumer<GraphDatabaseAPI> uniqueConstraintCreator) throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestEnterpriseGraphDatabaseFactory().newImpermanentDatabase();
        try {
            HalfAppliedConstraintRecoveryIT.createConstraint(db, uniqueConstraintCreator);
            LogicalTransactionStore txStore = (LogicalTransactionStore)db.getDependencyResolver().resolveDependency(LogicalTransactionStore.class);
            ArrayList<TransactionRepresentation> transactions = new ArrayList<TransactionRepresentation>();
            try (TransactionCursor cursor = txStore.getTransactions(2L);){
                cursor.forAll(tx -> transactions.add(tx.getTransactionRepresentation()));
            }
            ArrayList<TransactionRepresentation> arrayList = transactions;
            return arrayList;
        }
        finally {
            db.shutdown();
        }
    }

    private static void createConstraint(GraphDatabaseAPI db, Consumer<GraphDatabaseAPI> constraintCreator) {
        try (Transaction tx = db.beginTx();){
            constraintCreator.accept(db);
            tx.success();
        }
    }
}

