/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency;

import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EmbeddedDatabaseRule;
import org.neo4j.test.rule.SuppressOutput;

@RunWith(value=Parameterized.class)
public class ConsistencyCheckServiceRecordFormatIT {
    private final DatabaseRule db = new EmbeddedDatabaseRule().withSetting(OnlineBackupSettings.online_backup_enabled, "false").startLazily();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)SuppressOutput.suppressAll()).around((TestRule)this.db);
    @Parameterized.Parameter
    public String recordFormat;

    @Parameterized.Parameters(name="{0}")
    public static List<String> recordFormats() {
        return Arrays.asList("standard", "high_limit");
    }

    @Before
    public void configureRecordFormat() throws Exception {
        this.db.setConfig(GraphDatabaseSettings.record_format, this.recordFormat);
    }

    @Test
    public void checkTinyConsistentStore() throws Exception {
        this.db.ensureStarted(new String[0]);
        ConsistencyCheckServiceRecordFormatIT.createLinkedList((GraphDatabaseService)this.db, 1000);
        this.db.shutdownAndKeepStore();
        ConsistencyCheckServiceRecordFormatIT.assertConsistentStore((GraphDatabaseAPI)this.db);
    }

    private static void createLinkedList(GraphDatabaseService db, int size) {
        Node previous = null;
        try (Transaction tx = db.beginTx();){
            for (int i = 0; i < size; ++i) {
                TestLabel label = i % 2 == 0 ? TestLabel.FOO : TestLabel.BAR;
                Node current = db.createNode(new Label[]{label});
                current.setProperty("value", (Object)ThreadLocalRandom.current().nextLong());
                if (previous != null) {
                    previous.createRelationshipTo(current, (RelationshipType)TestRelType.FORWARD);
                    current.createRelationshipTo(previous, (RelationshipType)TestRelType.BACKWARD);
                }
                previous = current;
            }
            tx.success();
        }
    }

    private static void assertConsistentStore(GraphDatabaseAPI db) throws Exception {
        ConsistencyCheckService service = new ConsistencyCheckService();
        File storeDir = db.getStoreDir();
        ConsistencyCheckService.Result result = service.runFullConsistencyCheck(storeDir, Config.defaults(), ProgressMonitorFactory.textual((OutputStream)System.out), (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out), true);
        Assert.assertTrue((String)"Store is inconsistent", (boolean)result.isSuccessful());
    }

    private static enum TestRelType implements RelationshipType
    {
        FORWARD,
        BACKWARD;

    }

    private static enum TestLabel implements Label
    {
        FOO,
        BAR;

    }
}

