/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EnterpriseDatabaseRule;

public class ProcedureResourcesIT {
    @Rule
    public DatabaseRule db = new EnterpriseDatabaseRule();
    private final String indexDefinition = ":Label(prop)";
    private final ExecutorService executor = Executors.newSingleThreadExecutor();

    @After
    public void tearDown() throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(5L, TimeUnit.SECONDS);
    }

    @Test
    public void allProcedures() throws Exception {
        Map<String, List<Object>> allProceduresWithParameters = this.allProceduresWithParameters();
        this.createIndex();
        for (Map.Entry<String, List<Object>> procedureWithParams : allProceduresWithParameters.entrySet()) {
            this.initialData();
            this.verifyProcedureCloseAllAcquiredKernelStatements(procedureWithParams.getKey(), procedureWithParams.getValue());
            this.clearDb();
        }
    }

    private void initialData() {
        Label unusedLabel = Label.label((String)"unusedLabel");
        RelationshipType unusedRelType = RelationshipType.withName((String)"unusedRelType");
        String unusedPropKey = "unusedPropKey";
        try (Transaction tx = this.db.beginTx();){
            Node node1 = this.db.createNode(new Label[]{unusedLabel});
            node1.setProperty(unusedPropKey, (Object)"value");
            Node node2 = this.db.createNode(new Label[]{unusedLabel});
            node2.setProperty(unusedPropKey, (Object)1);
            node1.createRelationshipTo(node2, unusedRelType);
            tx.success();
        }
    }

    private void verifyProcedureCloseAllAcquiredKernelStatements(String procedureName, List<Object> parameters) throws ExecutionException, InterruptedException {
        String failureMessage = "Failed on procedure " + procedureName;
        try (Transaction outer = this.db.beginTx();){
            String procedureQuery = this.buildProcedureQuery(procedureName, parameters);
            this.exhaust(this.db.execute(procedureQuery)).close();
            this.exhaust(this.db.execute("MATCH (mo:Label) WHERE mo.prop = 'n/a' RETURN mo")).close();
            this.executeInOtherThread("CREATE(mo:Label) SET mo.prop = 'val' RETURN mo");
            Result result = this.db.execute("MATCH (mo:Label) WHERE mo.prop = 'val' RETURN mo");
            Assert.assertTrue((String)failureMessage, (boolean)result.hasNext());
            Map next = result.next();
            Assert.assertNotNull((String)failureMessage, next.get("mo"));
            this.exhaust(result);
            result.close();
            outer.success();
        }
    }

    private Result exhaust(Result execute) {
        while (execute.hasNext()) {
            execute.next();
        }
        return execute;
    }

    private void createIndex() {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("CREATE INDEX ON :Label(prop)");
            tx.success();
        }
        tx = this.db.beginTx();
        var2_2 = null;
        try {
            this.db.schema().awaitIndexesOnline(5L, TimeUnit.SECONDS);
            tx.success();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var2_2 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private String buildProcedureQuery(String procedureName, List<Object> parameters) {
        StringJoiner stringJoiner = new StringJoiner(",", "CALL " + procedureName + "(", ")");
        for (Object parameter : parameters) {
            stringJoiner.add(parameter.toString());
        }
        return stringJoiner.toString();
    }

    private void clearDb() {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("MATCH (n) DETACH DELETE n").close();
            tx.success();
        }
    }

    private Map<String, List<Object>> allProceduresWithParameters() {
        Set allProcedures = ((Procedures)this.db.getDependencyResolver().resolveDependency(Procedures.class)).getAllProcedures();
        HashMap<String, List<Object>> allProceduresWithParameters = new HashMap<String, List<Object>>();
        for (ProcedureSignature procedure : allProcedures) {
            List<Object> params = this.paramsFor(procedure);
            allProceduresWithParameters.put(procedure.name().toString(), params);
        }
        return allProceduresWithParameters;
    }

    private List<Object> paramsFor(ProcedureSignature procedure) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        switch (procedure.name().toString()) {
            case "db.createProperty": {
                parameters.add("'propKey'");
                break;
            }
            case "db.resampleIndex": {
                parameters.add("':Label(prop)'");
                break;
            }
            case "db.createRelationshipType": {
                parameters.add("'RelType'");
                break;
            }
            case "dbms.queryJmx": {
                parameters.add("'*:*'");
                break;
            }
            case "db.awaitIndex": {
                parameters.add("':Label(prop)'");
                parameters.add(100);
                break;
            }
            case "db.createLabel": {
                parameters.add("'OtherLabel'");
                break;
            }
            case "dbms.killQuery": {
                parameters.add("'query-1234'");
                break;
            }
            case "dbms.killQueries": {
                parameters.add("['query-1234']");
                break;
            }
            case "dbms.setTXMetaData": {
                parameters.add("{realUser:'MyMan'}");
                break;
            }
            case "dbms.listActiveLocks": {
                parameters.add("'query-1234'");
                break;
            }
        }
        return parameters;
    }

    private void executeInOtherThread(String query) throws ExecutionException, InterruptedException {
        Future<?> future = this.executor.submit(() -> {
            try (Transaction tx = this.db.beginTx();){
                this.exhaust(this.db.execute(query));
                tx.success();
            }
        });
        future.get();
    }
}

