/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.metrics.MetricsExtension;
import org.neo4j.metrics.MetricsSettings;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;

public class BatchingNeoStoresIT {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Test
    public void startBatchingNeoStoreWithMetricsPluginEnabled() throws Exception {
        FileSystemAbstraction fileSystem = this.fileSystemRule.get();
        File storeDir = this.testDirectory.graphDbDir();
        Config config = Config.defaults().with(MapUtil.stringMap((String[])new String[]{MetricsSettings.metricsEnabled.name(), "true"}));
        AssertableLogProvider provider = new AssertableLogProvider();
        SimpleLogService logService = new SimpleLogService((LogProvider)provider, (LogProvider)provider);
        BatchingNeoStores batchingNeoStores = BatchingNeoStores.batchingNeoStores((FileSystemAbstraction)fileSystem, (File)storeDir, (RecordFormats)RecordFormatSelector.defaultFormat(), (Configuration)Configuration.DEFAULT, (LogService)logService, (AdditionalInitialIds)AdditionalInitialIds.EMPTY, (Config)config);
        Throwable throwable = null;
        if (batchingNeoStores != null) {
            if (throwable != null) {
                try {
                    batchingNeoStores.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                batchingNeoStores.close();
            }
        }
        provider.assertNone(AssertableLogProvider.inLog(MetricsExtension.class).any());
    }
}

