/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.upgrade;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.junit.runners.Parameterized;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.highlimit.HighLimit;
import org.neo4j.kernel.impl.store.format.highlimit.v300.HighLimitV3_0_0;
import org.neo4j.test.Unzip;
import upgrade.StoreUpgraderTest;

public class EnterpriseStoreUpgraderTest
extends StoreUpgraderTest {
    public EnterpriseStoreUpgraderTest(String version) {
        super(version);
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> versions() {
        return Collections.singletonList(HighLimitV3_0_0.STORE_VERSION);
    }

    protected RecordFormats getRecordFormats() {
        return HighLimit.RECORD_FORMATS;
    }

    protected String getRecordFormatsName() {
        return "high_limit";
    }

    protected void prepareSampleDatabase(String version, FileSystemAbstraction fileSystem, File dbDirectory, File databaseDirectory) throws IOException {
        File resourceDirectory = this.findFormatStoreDirectoryForVersion(version, databaseDirectory);
        fileSystem.deleteRecursively(dbDirectory);
        fileSystem.mkdirs(dbDirectory);
        fileSystem.copyRecursively(resourceDirectory, dbDirectory);
    }

    private File findFormatStoreDirectoryForVersion(String version, File databaseDirectory) throws IOException {
        if (version.equals(HighLimitV3_0_0.STORE_VERSION)) {
            return this.highLimit3_0Store(databaseDirectory);
        }
        throw new IllegalArgumentException("Unknown enterprise store version.");
    }

    private File highLimit3_0Store(File databaseDirectory) throws IOException {
        return Unzip.unzip(EnterpriseStoreUpgraderTest.class, (String)"upgradeTest30HighLimitDb.zip", (File)databaseDirectory);
    }
}

