/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.commandline.dbms.VersionCommand;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.highlimit.v300.HighLimitV3_0_0;
import org.neo4j.kernel.internal.Version;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class VersionCommandEnterpriseTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Rule
    public DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    private Path databaseDirectory;
    private ArgumentCaptor<String> outCaptor;
    private VersionCommand command;
    private Consumer<String> out;

    @Before
    public void setUp() throws Exception {
        Path homeDir = this.testDirectory.directory("home-dir").toPath();
        this.databaseDirectory = homeDir.resolve("data/databases/foo.db");
        Files.createDirectories(this.databaseDirectory, new FileAttribute[0]);
        this.outCaptor = ArgumentCaptor.forClass(String.class);
        this.out = (Consumer)Mockito.mock(Consumer.class);
        this.command = new VersionCommand(this.out);
    }

    @Test
    public void readsEnterpriseStoreVersionCorrectly() throws Exception {
        this.prepareNeoStoreFile(HighLimitV3_0_0.RECORD_FORMATS.storeVersion());
        this.execute(this.databaseDirectory.toString());
        ((Consumer)Mockito.verify(this.out, (VerificationMode)Mockito.times((int)4))).accept(this.outCaptor.capture());
        Assert.assertEquals(Arrays.asList("Store format version:    vE.H.0", "Introduced in version:   3.0.0", "Superseded in version:   3.0.6", String.format("Current version:         %s", Version.getNeo4jVersion())), (Object)this.outCaptor.getAllValues());
    }

    private void execute(String storePath) throws Exception {
        this.command.execute(new String[]{"--store=" + storePath});
    }

    private void prepareNeoStoreFile(String storeVersion) throws IOException {
        File neoStoreFile = this.createNeoStoreFile();
        long value = MetaDataStore.versionStringToLong((String)storeVersion);
        MetaDataStore.setRecord((PageCache)this.pageCacheRule.getPageCache(this.fsRule.get()), (File)neoStoreFile, (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)value);
    }

    private File createNeoStoreFile() throws IOException {
        ((DefaultFileSystemAbstraction)this.fsRule.get()).mkdir(this.databaseDirectory.toFile());
        File neoStoreFile = new File(this.databaseDirectory.toFile(), "neostore");
        ((DefaultFileSystemAbstraction)this.fsRule.get()).create(neoStoreFile).close();
        return neoStoreFile;
    }
}

