/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.StoreVersion;
import org.neo4j.kernel.impl.store.format.highlimit.HighLimit;
import org.neo4j.kernel.impl.store.format.highlimit.v300.HighLimitV3_0_0;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_0;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_1;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_2;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;

public class RecordFormatsGenerationTest {
    @Test
    public void correctGenerations() {
        List<RecordFormats> recordFormats = Arrays.asList(StandardV2_0.RECORD_FORMATS, StandardV2_1.RECORD_FORMATS, StandardV2_2.RECORD_FORMATS, StandardV2_3.RECORD_FORMATS, StandardV3_0.RECORD_FORMATS, HighLimitV3_0_0.RECORD_FORMATS, HighLimit.RECORD_FORMATS);
        Map generationsForFamilies = recordFormats.stream().collect(Collectors.groupingBy(RecordFormats::getFormatFamily, Collectors.mapping(RecordFormats::generation, Collectors.toList())));
        Assert.assertEquals((long)2L, (long)generationsForFamilies.size());
        for (Map.Entry familyListGeneration : generationsForFamilies.entrySet()) {
            Assert.assertEquals((String)"Generation inside format family should be unique.", familyListGeneration.getValue(), RecordFormatsGenerationTest.distinct(familyListGeneration.getValue()));
        }
    }

    @Test
    public void uniqueGenerations() {
        Map<FormatFamily, List<Integer>> familyGenerations = RecordFormatsGenerationTest.allFamilyGenerations();
        for (Map.Entry<FormatFamily, List<Integer>> familyEntry : familyGenerations.entrySet()) {
            Assert.assertEquals((String)"Generation inside format family should be unique.", familyEntry.getValue(), RecordFormatsGenerationTest.distinct(familyEntry.getValue()));
        }
    }

    private static Map<FormatFamily, List<Integer>> allFamilyGenerations() {
        return Arrays.stream(StoreVersion.values()).map(StoreVersion::versionString).map(RecordFormatSelector::selectForVersion).collect(Collectors.groupingBy(RecordFormats::getFormatFamily, Collectors.mapping(RecordFormats::generation, Collectors.toList())));
    }

    private static List<Integer> distinct(List<Integer> integers) {
        return integers.stream().distinct().collect(Collectors.toList());
    }
}

